% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bglmnet.R
\name{plot.bglmnet}
\alias{plot.bglmnet}
\title{Plot diagnostics for a bglmnet object}
\usage{
\method{plot}{bglmnet}(x, highlight, classic = FALSE, tag = NULL,
  which = c("boot", "vip"), width = 800, height = 400, fontSize = 12,
  left = 50, top = 30, chartWidth = "60\%", chartHeight = "80\%",
  axisTitlesPosition = "out", dataOpacity = 0.5, options = NULL,
  hAxis.logScale = TRUE, backgroundColor = "transparent", plb = 0.01, ...)
}
\arguments{
\item{x}{\code{bglmnet} object, the result of \code{\link{bglmnet}}}

\item{highlight}{the name of a variable that will be highlighted.}

\item{classic}{logical.  If \code{classic=TRUE} a
base graphics plot is provided instead of a googleVis plot.
Default is \code{classic=FALSE}.}

\item{tag}{Default NULL. Name tag of the objects to be extracted
from a gvis (googleVis) object.

The default tag for is NULL, which will
result in R opening a browser window.  Setting \code{tag='chart'}
or setting \code{options(gvis.plot.tag='chart')} is useful when
googleVis is used in scripts, like knitr or rmarkdown.}

\item{which}{a vector specifying the plots to be output. Variable
inclusion type plots \code{which="vip"} or model description loss against
penalty parameter \code{which="boot"}.}

\item{width}{Width of the googleVis chart canvas area, in pixels.
Default: 800.}

\item{height}{Height of the googleVis chart canvas area, in pixels.
Default: 400.}

\item{fontSize}{font size used in googleVis chart.  Default: 12.}

\item{left}{space at left of chart (pixels?).  Default: "50".}

\item{top}{space at top of chart (pixels?).  Default: "30".}

\item{chartWidth}{googleVis chart area width.
A simple number is a value in pixels;
a string containing a number followed by \code{\%} is a percentage.
Default: \code{"60\%"}}

\item{chartHeight}{googleVis chart area height.
A simple number is a value in pixels;
a string containing a number followed by \code{\%} is a percentage.
Default: \code{"80\%"}}

\item{axisTitlesPosition}{Where to place the googleVis axis titles,
compared to the chart area. Supported values:
"in" - Draw the axis titles inside the the chart area.
"out" - Draw the axis titles outside the chart area.
"none" - Omit the axis titles.}

\item{dataOpacity}{The transparency of googleVis data points,
with 1.0 being completely opaque and 0.0 fully transparent.}

\item{options}{a list to be passed to the googleVis function giving
complete control over the output.  Specifying a value for
\code{options} overwrites all other plotting variables.}

\item{hAxis.logScale}{logical, whether or not to use a log scale on
the horizontal axis. Default = TRUE.}

\item{backgroundColor}{The background colour for the main area
of the chart. A simple HTML color string,
for example: 'red' or '#00cc00'.  Default: 'transparent'}

\item{plb}{lower bound on the probability of a model being selected. If
a model has a selection probability lower than plb it will not be
plotted.}

\item{...}{further arguments (currently unused)}
}
\description{
A plot method to visualise the results of a \code{bglmnet} object.
}
\seealso{
\code{\link{bglmnet}}
}

