% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_related.R
\name{gg_plot}
\alias{gg_plot}
\title{Plot Diagnostic for a \code{glm.cmp} Object in ggplot}
\usage{
gg_plot(
  x,
  which = c(1L, 2L, 6L, 8L),
  bins = 10,
  ask = TRUE,
  nrow = NULL,
  ncol = NULL,
  output_as_ggplot = TRUE
)
}
\arguments{
\item{x}{an object class 'cmp' object, obtained from a call to \code{glm.cmp}}

\item{which}{if a subset of plots is required, specify a subset of the numbers 1:8.
See 'Details' below.}

\item{bins}{numeric; the number of bins shown in the PIT histogram or the
PIT Q-Q plot.}

\item{ask}{logical; if \code{TRUE}, the user is asked before each plot.}

\item{nrow}{numeric; (optional) number of rows in the plot grid.}

\item{ncol}{numeric; (optional) number of columns in the plot grid.}

\item{output_as_ggplot}{logical; if \code{TRUE}, the function would
return a list of \code{ggplot} objects; if \code{FALSE}, the
function would return an \code{ggarrange} object.}
}
\value{
return a list of \code{ggplot} objects or a \code{ggarrange} object.
}
\description{
Eight plots (selectable by \code{which}) are currently available:
a plot of deviance residuals against fitted values,
a non-randomized PIT histogram,
a uniform Q-Q plot for non-randomized PIT,
a histogram of the normal randomized residuals,
a Q-Q plot of the normal randomized residuals,
a Scale-Location plot of sqrt(| residuals |) against fitted values
a plot of Cook's distances versus row labels
a plot of pearson residuals against leverage.
By default, four plots (number 1, 2, 6, and 8 from this list of plots) are provided.
}
\details{
The 'Scale-Location' plot, also called 'Spread-Location' plot, takes the square root of
the absolute standardized deviance residuals (\emph{sqrt|E|}) in order to diminish
skewness is much less skewed than than \emph{|E|} for Gaussian zero-mean E.

The 'Scale-Location' plot uses the standardized deviance residuals while the
Residual-Leverage plot uses the standardized pearson residuals. They are given as
\eqn{R_i/\sqrt{1-h_{ii}}} where \eqn{h_{ii}} are the diagonal entries of the hat matrix.

The Residuals-Leverage plot shows contours of equal Cook's distance for values of 0.5
and 1.

There are two plots based on the non-randomized probability integral transformation (PIT)
using \code{\link{compPIT}}. These are a histogram and a uniform Q-Q plot. If the
model assumption is appropriate, these plots should reflect a sample obtained
from a uniform distribution.

There are also two plots based on the normal randomized residuals calculated
using \code{\link{compnormRandPIT}}. These are a histogram and a normal Q-Q plot. If the model
assumption is appropriate, these plots should reflect a sample obtained from a normal
distribution.
}
\examples{
data(takeoverbids)
M.bids <- glm.cmp(numbids ~ leglrest + rearest + finrest + whtknght 
    + bidprem + insthold + size + sizesq + regulatn, data=takeoverbids)

## The default plots are shown
gg_plot(M.bids)

## The plots for the non-randomized PIT 
gg_plot(M.bids, which = c(2,3))
}
\seealso{
\code{\link{compPIT}}, \code{\link{compnormRandPIT}},
\code{\link{glm.cmp}} and \code{\link{plot.cmp}}.
}
