% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location_functions.R
\name{decrypt_gps}
\alias{decrypt_gps}
\title{Decrypt GPS data from a curve25519 public key}
\usage{
decrypt_gps(data, key)
}
\arguments{
\item{data}{A (lazy) tibble containing the GPS data}

\item{key}{A curve25519 public key}
}
\value{
A tibble containing the non-lazy, decrypted GPS data
}
\description{
By default, the latitude and longitude of the GPS data collected by m-Path Sense will be encrypted
using an asymmetric curve25519 key to provide extra protection for these highly sensitive data.
This function takes the entire location data set and decrypts its longitude and latitude columns
using the provided \code{key}.
}
