% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_raw_view}
\alias{get_raw_view}
\title{Get view from Pose video data}
\usage{
get_raw_view(
  recording,
  vid,
  direct,
  inst,
  out_folder = tempdir(),
  save_output = FALSE,
  filetype = "rda",
  verbose = FALSE
)
}
\arguments{
\item{recording}{\code{Recording} object.}

\item{vid}{video camera.}

\item{direct}{direction.}

\item{inst}{instrument.}

\item{out_folder}{output folder (tempdir if nothing is given).}

\item{save_output}{save the output?}

\item{filetype}{type of file ('rda' as default), can be 'csv'.}

\item{verbose}{messages the specific data loaded (default is 'FALSE').}
}
\value{
a \code{RawView} object.
}
\description{
Creates time reference and displacement from raw csv data for the view.
}
\examples{
r <- get_sample_recording()
v <- get_raw_view(r, "Central", "", "Sitar")
}
\seealso{
Other data functions: 
\code{\link{apply_filter_sgolay}()},
\code{\link{get_data_points}()},
\code{\link{get_duration_annotation_data}()},
\code{\link{get_feature_data}()},
\code{\link{get_filtered_views}()},
\code{\link{get_joined_view}()},
\code{\link{get_metre_data}()},
\code{\link{get_onsets_selected_data}()},
\code{\link{get_processed_views}()},
\code{\link{get_processed_view}()},
\code{\link{get_raw_optflow_view}()},
\code{\link{get_raw_views}()},
\code{\link{get_recording}()},
\code{\link{get_sample_recording}()}
}
\concept{data functions}
