% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_processed_view}
\alias{get_processed_view}
\title{Get processed view from Pose video data}
\usage{
get_processed_view(
  rv,
  folder_out = tempdir(),
  save_output = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{rv}{\code{RawView} object.}

\item{folder_out}{output folder relative to recording home (default is 'Normalized').}

\item{save_output}{save the output?}

\item{verbose}{messages the specific data loaded (default is 'FALSE').}
}
\value{
a \code{ProcessedView} object.
}
\description{
Normalises and interpolates missing data in the view.
}
\examples{
r <- get_sample_recording()
rv <- get_raw_view(r, "Central", "", "Sitar")
pv <- get_processed_view(rv)
}
\seealso{
Other data functions: 
\code{\link{apply_filter_sgolay}()},
\code{\link{get_data_points}()},
\code{\link{get_duration_annotation_data}()},
\code{\link{get_feature_data}()},
\code{\link{get_filtered_views}()},
\code{\link{get_joined_view}()},
\code{\link{get_metre_data}()},
\code{\link{get_onsets_selected_data}()},
\code{\link{get_processed_views}()},
\code{\link{get_raw_optflow_view}()},
\code{\link{get_raw_views}()},
\code{\link{get_raw_view}()},
\code{\link{get_recording}()},
\code{\link{get_sample_recording}()}
}
\concept{data functions}
