% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_sims.R
\name{fitting_model}
\alias{fitting_model}
\title{Fit continuous-time movement models}
\usage{
fitting_model(
  obj,
  set_target = c("hr", "ctsd"),
  .dur = NULL,
  .dti = NULL,
  .tau_p = NULL,
  .tau_v = NULL,
  .error_m = NULL,
  .check_sampling = FALSE,
  .rerun = FALSE,
  .parallel = TRUE,
  .trace = FALSE
)
}
\arguments{
\item{obj}{A list of simulated movement datasets.}

\item{set_target}{A character vector indicating the research target(s). Options:
\itemize{
\item \code{"hr"} - Home range estimation.
\item \code{"ctsd"} - Speed and distance estimation.
}}

\item{.dur}{Numeric, sampling duration of the simulated data (required if \code{.check_sampling = TRUE}).}

\item{.dti}{Numeric, sampling interval of simulated data (required if \code{.check_sampling = TRUE}).}

\item{.tau_p}{List, position autocorrelation timescale (optional).}

\item{.tau_v}{List, velocity autocorrelation timescale (optional).}

\item{.error_m}{Numeric, if simulating a dataset with location error (in meters).}

\item{.check_sampling}{Logical; if \code{TRUE}, checks if the sampling schedule is optimal for ctmm.fit().}

\item{.rerun}{Logical; if \code{TRUE}, re-runs model selection if effective sample sizes fall below threshold.}

\item{.parallel}{Logical; if \code{TRUE}, enables parallel computation for efficiency. Default is \code{TRUE}.}

\item{.trace}{Logical; if \code{TRUE}, prints additional information.}
}
\value{
A list of fitted movement models, one per simulation.
}
\description{
This function fits continuous-time movement models to simulated location
data using the \code{ctmm} package. It estimates movement parameters for each
simulated trajectory, optionally running in parallel for efficiency.
}
\details{
The function first generates initial parameter estimates using \code{ctmm::ctmm.guess()}.
It then selects the best movement model for each simulation using \code{par.ctmm.select()}.
The function ensures that each fitted model is centered at the origin (\code{x = 0, y = 0}) before returning.
}
