% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movealloc.R
\name{movealloc}
\alias{movealloc}
\title{R function for calculating slope-dependant walking-cost allocation to origins}
\usage{
movealloc(
  dtm = NULL,
  origin,
  studyplot = NULL,
  funct = "t",
  time = "h",
  move = 16,
  cogn.slp = FALSE,
  sl.crit = 10,
  W = 70,
  L = 0,
  N = 1,
  V = 1.2,
  z = 9,
  isolines = FALSE,
  breaks = NULL,
  cont.lab = TRUE,
  cex.breaks = 0.6,
  leg.alloc = FALSE,
  leg.pos = "topright",
  cex.leg = 0.75,
  transp = 0.5,
  export = FALSE
)
}
\arguments{
\item{dtm}{Digital Terrain Model (RasterLayer class); if not provided, elevation data will be acquired online for the area enclosed by the 'studyplot' parameter (see \code{\link{movecost}}).}

\item{origin}{location(s) in relation to which the cost allocation is carried out (SpatialPointsDataFrame class).}

\item{studyplot}{polygon (SpatialPolygonDataFrame class) representing the study area for which online elevation data are aquired (see \code{\link{movecost}}); NULL is default.}

\item{funct}{cost function to be used (for details on each of the following, see \code{\link{movecost}}):\cr

\strong{-functions expressing cost as walking time-}\cr
\strong{t} (default) uses the on-path Tobler's hiking function;\cr
\strong{tofp} uses the off-path Tobler's hiking function;\cr
\strong{mp} uses the Marquez-Perez et al.'s modified Tobler's function;\cr
\strong{icmonp} uses the Irmischer-Clarke's hiking function (male, on-path);\cr
\strong{icmoffp} uses the Irmischer-Clarke's hiking function (male, off-path);\cr
\strong{icfonp} uses the Irmischer-Clarke's hiking function (female, on-path);\cr
\strong{icfoffp} uses the Irmischer-Clarke's hiking function (female, off-path);\cr
\strong{ug} uses the Uriarte Gonzalez's walking-time cost function;\cr
\strong{ma} uses the Marin Arroyo's walking-time cost function;\cr
\strong{alb} uses the Alberti's Tobler hiking function modified for pastoral foraging excursions;\cr
\strong{gkrs} uses the Garmy, Kaddouri, Rozenblat, and Schneider's hiking function;\cr
\strong{r} uses the Rees' hiking function;\cr
\strong{ks} uses the Kondo-Seino's hiking function;\cr

\strong{-functions for wheeled-vehicles-}\cr
\strong{wcs} uses the wheeled-vehicle critical slope cost function;\cr

\strong{-functions expressing abstract cost-}\cr
\strong{ree} uses the relative energetic expenditure cost function;\cr
\strong{b} uses the Bellavia's cost function;\cr

\strong{-functions expressing cost as metabolic energy expenditure-}\cr
\strong{p} uses the Pandolf et al.'s metabolic energy expenditure cost function;\cr
\strong{pcf} uses the Pandolf et al.'s cost function with correction factor for downhill movements;\cr
\strong{m} uses the Minetti et al.'s metabolic energy expenditure cost function;\cr
\strong{hrz} uses the Herzog's metabolic energy expenditure cost function;\cr
\strong{vl} uses the Van Leusen's metabolic energy expenditure cost function;\cr
\strong{ls} uses the Llobera-Sluckin's metabolic energy expenditure cost function;\cr
\strong{a} uses the Ardigo et al.'s metabolic energy expenditure cost function (for all the mentioned cost functions, see Details);\cr}

\item{time}{time-unit expressed by the isoline(s) if Tobler's and other time-related cost functions are used;
'h' for hour, 'm' for minutes.}

\item{move}{number of directions in which cells are connected: 4 (rook's case), 8 (queen's case), 16 (knight and one-cell queen moves; default).}

\item{cogn.slp}{TRUE or FALSE (default) if the user wants or does not want the 'cognitive slope' to be used in place of the real slope (see \code{\link{movecost}}).}

\item{sl.crit}{critical slope (in percent), typically in the range 8-16 (10 by default) (used by the wheeled-vehicle cost function; see \code{\link{movecost}}).}

\item{W}{walker's body weight (in Kg; 70 by default; used by the Pandolf's and Van Leusen's cost function; see \code{\link{movecost}}).}

\item{L}{carried load weight (in Kg; 0 by default; used by the Pandolf's and Van Leusen's cost function; see \code{\link{movecost}}).}

\item{N}{coefficient representing ease of movement (1 by default) (see \code{\link{movecost}}).}

\item{V}{speed in m/s (1.2 by default) (used by the Pandolf et al.'s, Pandolf et al.s with correction factor, Van Leusen's, and Ardigo et al.'s cost function; if set to 0, it is internally worked out on the basis of Tobler on-path hiking function (see \code{\link{movecost}}).}

\item{z}{zoom level for the elevation data downloaded from online sources (from 0 to 15; 9 by default) (see \code{\link{movecost}} and \code{\link[elevatr]{get_elev_raster}}).}

\item{isolines}{TRUE or FALSE (default) is the user wants or does not want cost isolines/contours around the origins to be calculated and plotted.}

\item{breaks}{contours' (i.e., isolines') interval; if no value is supplied, the interval is set by default to 1/10 of the range of values of the cost surface accumulated around the origins.}

\item{cont.lab}{if set to TRUE (default) display the labels of the cost contours.}

\item{cex.breaks}{set the size of the labels attached to the cost contours (0.6 by default).}

\item{leg.alloc}{if set to TRUE, display the legend in the plotted cost allocation raster; FALSE by default.}

\item{leg.pos}{set the position of the legend in the plotted cost allocation raster; 'topright' by default (other options: "bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right", "center").}

\item{cex.leg}{set the size of the labels used in the legend displayed in the plotted allocation raster (0.75 by default).}

\item{transp}{set the transparency of the hillshade raster that is plotted over the cost allocation raster (0.5 by default).}

\item{export}{TRUE or FALSE (default) if the user wants or does not want the output to be exported; if TRUE, the isolines (i.e. the contours) and the allocation boundaries will be exported as a shapefile;
the cost allocation raster will be exported as 'GeoTiff'; the DTM is exported only if it was not provided by the user and downloaded by the function from online sources; all the exported files (excluding the DTM)
will bear a suffix corresponding to the cost function selected by the user.}
}
\value{
The function returns a list storing the following components \itemize{
 \item{dtm: }{Digital Terrain Model ('RasterLayer' class)}
 \item{cost.allocation.raster: }{raster of the cost allocation ('RasterLayer' class)}
 \item{isolines: }{contour lines representing the accumulated cost around the origins ('SpatialLinesDataFrame' class); returned if the 'isolines' parameter is set to TRUE}
 \item{alloc.boundaries: }{polygons representing the allocation zones ('SpatialPolygonsDataFrame' class)}
}
}
\description{
The function provides the facility to carry out a cost allocation analysis. Given a number of origin locations,
a cost allocation raster is produced; each cell of the cost allocation raster is given an integer indicating to which origin
a cell is closer in terms of cost. Needless to say, the cost can be conceptualized in terms of either walking time or
energy expenditure, and is function of the terrain slope.\cr
}
\details{
The function requires an input DTM ('RasterLayer' class) and a dataset ('SpatialPointsDataFrame' class) containing the
origin locations. If a DTM is not provided, 'movealloc()' will download elevation data from online sources (see \code{\link{movecost}} for more details).
Under the hood, 'movealloc()' relies on the 'movecost()' function and implements the same cost functions:
see the help documentation of 'movecost()' for further information.\cr

Internally, what 'movealloc()' does is producing an accumulated cost surface around each individual origin location; those
accumulated cost surfaces are then stacked together, and then the function looks at each pixel in the stack of surfaces and
returns 1 if the first stacked surface has the smallest pixel value, or 2 if the second stacked surface has the smallest pixel value, and so on for bigger stacks.\cr

'movealloc()' produces a plot featuring an hillshade image that is overlaid by the cost allocation raster and by a polygon layer
where each polygon represents the limits of each allocation zone. A legend can be optionally added to the plot via the 'leg.alloc' parameter (FALSE by default).
Isolines (i.e., contour lines) around each origin location can be optionally plotted via the 'isolines' parameter (FALSE by default).\cr

The DTM, the cost allocation raster, the cost allocation polygons, and the isolines (if requested by the user by setting the 'isolines' parameter to TRUE), can
be exported by setting the 'export' parameter to TRUE. All the exported files (excluding the DTM) will bear a suffix corresponding to the cost function selected by the user.
}
\examples{
# load a sample Digital Terrain Model
volc <- raster::raster(system.file("external/maungawhau.grd", package="gdistance"))


# load the sample locations on the above DTM
data(destin.loc)


#carry out a cost allocation analysis using the Tobler's off-path hiking function,
#setting the time to minutes and the isolines (i.e., contours) interval to 1 minute;
#only 3 locations are used

#result <- movealloc(dtm=volc, origin=destin.loc[c(3,7,9),], funct="tofp", time="m",
#breaks=1, isolines=TRUE)


#same as above, using all the locations and the Kondo-Seino's cost function

#result <- movealloc(dtm=volc, origin=destin.loc, funct="ks", time="m",
#breaks=1, isolines=TRUE)


}
\seealso{
\code{\link{movecost}}
}
\keyword{movealloc}
