% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nLogLike.R
\name{nLogLike}
\alias{nLogLike}
\title{Negative log-likelihood function}
\usage{
nLogLike(
  wpar,
  nbStates,
  bounds,
  parSize,
  data,
  stepDist = c("gamma", "weibull", "lnorm", "exp"),
  angleDist = c("vm", "wrpcauchy", "none"),
  angleMean = NULL,
  zeroInflation = FALSE,
  stationary = FALSE,
  knownStates = NULL
)
}
\arguments{
\item{wpar}{Vector of working parameters.}

\item{nbStates}{Number of states of the HMM.}

\item{bounds}{Matrix with 2 columns and as many rows as there are elements in \code{wpar}. Each row
contains the lower and upper bound for the correponding parameter.}

\item{parSize}{Vector of two values: number of parameters of the step length distribution,
number of parameters of the turning angle distribution.}

\item{data}{An object \code{moveData}.}

\item{stepDist}{Name of the distribution of the step lengths (as a character string).
Supported distributions are: gamma, weibull, lnorm, exp. Default: gamma.}

\item{angleDist}{Name of the distribution of the turning angles (as a character string).
Supported distributions are: vm, wrpcauchy. Set to \code{"none"} if the angle distribution should
not be estimated. Default: vm.}

\item{angleMean}{Vector of means of turning angles if not estimated (one for each state).
Default: \code{NULL} (the angle mean is estimated).}

\item{zeroInflation}{\code{TRUE} if the step length distribution is inflated in zero.
Default: \code{FALSE}. If \code{TRUE}, initial values for the zero-mass parameters should be
included in \code{stepPar0}.}

\item{stationary}{\code{FALSE} if there are covariates. If \code{TRUE}, the initial distribution is considered
equal to the stationary distribution. Default: \code{FALSE}.}

\item{knownStates}{Vector of values of the state process which are known prior to fitting the
model (if any). Default: NULL (states are not known). This should be a vector with length the number
of rows of 'data'; each element should either be an integer (the value of the known states) or NA if
the state is not known.}
}
\value{
The negative log-likelihood of the parameters given the data.
}
\description{
Negative log-likelihood function
}
\examples{
\dontrun{
# data is a moveData object (as returned by prepData), automatically loaded with the package
data <- example$data
simPar <- example$simPar
par0 <- example$par0

estAngleMean <- is.null(simPar$angleMean)
bounds <- parDef(simPar$stepDist,simPar$angleDist,simPar$nbStates,
                 estAngleMean,simPar$zeroInflation)$bounds
parSize <- parDef(simPar$stepDist,simPar$angleDist,simPar$nbStates,
                  estAngleMean,simPar$zeroInflation)$parSize

par <- c(par0$stepPar0,par0$anglePar0)
wpar <- n2w(par,bounds,par0$beta0,par0$delta0,simPar$nbStates,FALSE)

l <- nLogLike(wpar=wpar,nbStates=simPar$nbStates,bounds=bounds,parSize=parSize,data=data,
             stepDist=simPar$stepDist,angleDist=simPar$angleDist,angleMean=simPar$angleMean,
             zeroInflation=simPar$zeroInflation)
}

}
