% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chr.disp.sim.R
\name{chr.disp.sim}
\alias{chr.disp.sim}
\title{Simulate character displacement data}
\usage{
chr.disp.sim(phy, n.steps = 1000, sigma = 1, a = 0, ntraits = 1,
  sympatry = NA, allopatry = NA, trait.lim = NA)
}
\arguments{
\item{phy}{An object of class \code{phylo} (see \pkg{ape}).}

\item{n.steps}{Number of time steps the for the simulation (default = 1000 time steps).}

\item{sigma}{The value of Brownian variance in the simulation}

\item{a}{The strength of competition between inter-specific lineages}

\item{ntraits}{Number of traits to be simulated}

\item{sympatry}{an optional matrix giving the time that each pair of species starts to interact}

\item{allopatry}{an optional matrix giving the times when species stop interacting}

\item{trait.lim}{an optional parameter that puts limits on the available trait-space, preventing trait values with magnitude greater than the value of lim}
}
\value{
A list containing the the simulated data (tval) showing the sigma, a, mean gap and gap standard deviation. Additionally, if used, the user input sympatry (symp) and/or allopatry (allo) matrices
}
\description{
Simulates data under a Brownian motion or character displacement model
}
\examples{
## import finch data form Clarke et al. (2017)
data(finches)
emp.tree <- finch.tree
emp.data <- finch.data
## simulate small amount of data 
## (example only - many more datasets are required for accuracy)
sim.data <- chr.disp.sim(emp.tree, n.steps=100,
sigma=1, a=2, ntraits=1, sympatry=NA, allopatry=NA, trait.lim=NA)
}
\references{
Clarke M, Thomas GH, Freckleton RP. 2017. Trait evolution in adaptive radiations: modelling and measuring interspecific competition on phylogenies. The American Naturalist. 189, 121-137.
}
\seealso{
\code{\link{chr.disp.param}}, \code{\link{chr.disp.lrt}}
}
\author{
Magnus Clarke and Mark Puttick
}
