% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiscaleMosum_merging.R
\name{multiscale.cpts}
\alias{multiscale.cpts}
\title{Multiscale MOSUM algorithm (sBIC)}
\usage{
multiscale.cpts(x, G = bandwidths.default(length(x)),
  threshold = c("critical.value", "custom")[1], alpha = 0.05,
  threshold.function = NULL, rule = c("pval", "peak")[1],
  criterion = c("eta", "epsilon")[1], eta = 0.4, epsilon = 0.2,
  penalty = c("log", "polynomial")[1], pen.exp = 1.1, bootstrap = F,
  N_bootstrap, alpha_CI = 0.05, ...)
}
\arguments{
\item{x}{input data (\code{numeric} vector or object of class \code{ts})}

\item{G}{an asymmetric bandwidth grid;
either an object of type \code{multiscale.grid} or an integer vector
of one-sided bandwidths to be passed as parameter to \link[mosum]{multiscale.grid}}

\item{threshold}{string indicating which threshold should be used to determine significance.
By default, \code{mosum.criticalValue} is used for each bandwidth (with significance
level \code{alpha}). Alternatively, it is possible to parse a user-defined function 
with \code{threshold.function};}

\item{alpha}{a numeric value for the significance level with
\code{0 <= alpha <= 1}. Use iff \code{threshold="critical.value"}}

\item{threshold.function}{function object of form \code{function(G_l,G_r)}, to compute a
threshold of significance for different bandwidths (G_l,G_r); use iff \code{threshold="custom"}}

\item{rule}{string for the choice of sorting criterion in merging step. 
Possible values are: 
\itemize{
\item{\code{pval} = lowest p-value}, 
\item{\code{peak} = largest (rescaled) peak.}
}}

\item{criterion}{Criterion how changepoint candidates are generated,
to be parsed to \link[mosum]{mosum.cpts}}

\item{eta, epsilon}{see \link[mosum]{mosum.cpts}}

\item{penalty}{string indicating which kind of penalty term is used; possible values are:
\itemize{
\item{\code{log}: in this case, penalty(n)=log(n)^pen.exp}
\item{\code{polynomial}: in this case, penalty=n^pen.exp}
}}

\item{pen.exp}{exponent for penalty term (see \code{penalty});}

\item{bootstrap}{flag indicating whether bootstrap replicates of estimated changepoints
should be computed}

\item{N_bootstrap}{number of bootstrap replicates to be generated (iff bootstrap)}

\item{alpha_CI}{numeric value in (0,1), such that the (1-alpha_CI)-confidence bootstrap intervals are computed (iff bootstrap)}

\item{...}{further arguments to be parsed to \link[mosum]{mosum} calls}
}
\value{
S3 \code{multiscale.cpts} object, which contains the following fields:
   \item{x}{the numeric input vector provided}
   \item{cpts}{estimated changepoints after merging}
   \item{cpts.info}{data frame containing information about estimated changepoints}
   \item{bic}{sBIC value of estimated changepoint set}
   \item{pooled.cpts}{set of changepoint candidates that have been considered during the algorithm}
   \item{G,rule,criterion}{input parameter}
   \item{threshold,threshold.function}{input parameter}
   \item{eta,epsilon,penalty,pen.exp}{input parameter}
   \item{bootstrap}{input parameter}
   \item{cpts_bootstrap}{bootstrap replicates and CIs, object of class \link[mosum]{cpts.bootstrap} (iff bootstrap)}
}
\description{
Multiscale MOSUM procedure with sBIC merging
}
\details{
See Algorithm 2 in the first referenced paper for a comprehensive
description of the procedure and further details.
}
\examples{
x <- piecewiseStationary_timeSeries(model="mix")
mcpts <- multiscale.cpts(x, G=c(8,15,30,70))
print(mcpts$cpts)
print(mcpts$cpts.info)
par(mfcol=c(2,1), mar=c(2,4,2,2))
plot.ts(x)
abline(v=mcpts$cpts, col=2)
plot(mcpts)
}
\references{
A. Meier, C. Kirch and H. Cho.
\emph{mosum: A Package for Moving Sums in Change Point Analysis.}
Unpublished manuscript, 2018+.

H. Cho and C. Kirch.
\emph{Multiple change-point detection via multiscale MOSUM procedure with localized pruning.}
Unpublished manuscript, 2018+.
}
