% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasetsDoc.R
\docType{data}
\name{Births2015}
\alias{Births2015}
\title{US Births in 2015}
\format{A data frame with 365 observations on the following variables.
  \itemize{
    \item{\code{date}} {date in 2015}
    \item{\code{births}} {number of US births}
    \item{\code{dayofyear}} {sequential number of days from 1 to 365}
    \item{\code{wday}} {day of week as an ordered factor}
  }}
\source{
Obtained from the National Center for Health Statistics,  
National Vital Statistics System,  
Natality, 2015 data.
}
\usage{
data(Births2015)
}
\description{
A day by day record of the number of births in the United States in 2015.
}
\examples{
data(Births2015)
if (require(lattice)) {
  xyplot(births ~ date, Births2015)
  xyplot(births ~ date, Births2015, groups = wday)
}
if (require(dplyr)) {
  Births78 \%>\% 
    group_by(wday) \%>\% summarise(births = sum(births)) \%>\% 
    ungroup() \%>\% mutate(frac = births / sum(births))
  Births2015 \%>\% 
    group_by(wday) \%>\% summarise(births = sum(births)) \%>\% 
    ungroup() \%>\% mutate(frac = births / sum(births))
}
}
\seealso{
\code{\link{Births78}}, \code{\link{Births}}
}
