% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oddsRatio.R
\name{orrr}
\alias{orrr}
\alias{oddsRatio}
\alias{relrisk}
\alias{print.oddsRatio}
\alias{print.relrisk}
\alias{summary.oddsRatio}
\alias{summary.relrisk}
\title{Odds Ratio and Relative Risk for 2 x 2 Contingency Tables}
\usage{
orrr(x, conf.level = 0.95, verbose = !quiet, quiet = TRUE, digits = 3,
  relrisk = FALSE)

oddsRatio(x, conf.level = 0.95, verbose = !quiet, quiet = TRUE,
  digits = 3)

relrisk(x, conf.level = 0.95, verbose = !quiet, quiet = TRUE,
  digits = 3)

\method{print}{oddsRatio}(x, digits = 4, ...)

\method{print}{relrisk}(x, digits = 4, ...)

\method{summary}{oddsRatio}(object, digits = 4, ...)

\method{summary}{relrisk}(object, digits = 4, ...)
}
\arguments{
\item{x}{a 2 X 2 matrix, data frame or table of counts}

\item{conf.level}{the confidence interval level}

\item{verbose}{a logical indicating whether verbose output should be displayed}

\item{quiet}{a logical indicating whether verbose output should be suppressed}

\item{digits}{number of digits to display}

\item{relrisk}{a logical indicating whether the relative risk should be returned
instead of the odds ratio}

\item{...}{additional arguments}

\item{object}{an R object to print or summarise.  Here an object of class
\code{"oddsRatio"} or \code{"relrisk"}.}
}
\value{
an odds ratio or relative risk.  If \code{verpose} is true,
more details and the confidence intervals are displayed.
}
\description{
This function calculates the odds ratio and relative risk for a 2 x 2
contingency table and a
confidence interval (default \code{conf.level} is 95 percent) for the
each estimate. \code{x} should be a matrix, data frame or table. "Successes"
should be located in column 1 of \code{x}, and the treatment of interest
should be located in row 2. The odds ratio is calculated as (Odds row 2) /
(Odds row 1). The confidence interval is calculated from the log(OR) and
backtransformed.
}
\examples{
M1 <- matrix(c(14, 38, 51, 11), nrow = 2)
M1
oddsRatio(M1)

M2 <- matrix(c(18515, 18496, 1427, 1438), nrow = 2)
rownames(M2) <- c("Placebo", "Aspirin")
colnames(M2) <- c("No", "Yes")
M2
oddsRatio(M2)
oddsRatio(M2, verbose=TRUE)
relrisk(M2, verbose=TRUE)
if (require(mosaicData)) {
relrisk(tally(~ homeless + sex, data=HELPrct) )
do(3) * relrisk( tally( ~ homeless + shuffle(sex), data=HELPrct) )
}
}
\seealso{
\code{\link[=chisq.test]{chisq.test()}}, \code{\link[=fisher.test]{fisher.test()}}
}
\author{
Kevin Middleton (\email{kmm@csusb.edu}); modified by
R Pruim.
}
\keyword{stats}
