% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpqrdist.R
\name{qdist}
\alias{qdist}
\alias{xqgamma}
\alias{xqt}
\alias{xqchisq}
\alias{xqf}
\alias{xqbinom}
\alias{xqpois}
\alias{xqgeom}
\alias{xqnbinom}
\alias{xqbeta}
\title{Illustrated quantile calculations from distributions}
\usage{
qdist(dist = "norm", p, plot = TRUE, verbose = FALSE, invisible = FALSE,
  resolution = 500L, digits = 3L, xlim, ylim, return = c("values",
  "plot"), ..., refinements = list())

xqgamma(...)

xqt(...)

xqchisq(...)

xqf(...)

xqbinom(...)

xqpois(...)

xqgeom(...)

xqnbinom(...)

xqbeta(...)
}
\arguments{
\item{dist}{a character discription of a distribution, for example 
\code{"norm"}, \code{"t"}, or \code{"chisq"}}

\item{p}{a vector of probabilities}

\item{plot}{a logical indicating whether a plot should be created}

\item{verbose}{a logical}

\item{invisible}{a logical}

\item{resolution}{number of points used for detecting discreteness and generating plots.
The defaut value of 5000 should work well except for discrete distributions
that have many distinct values, especially if these values are not evenly spaced.}

\item{digits}{the number of digits desired}

\item{xlim}{x limits.  By default, these are chosen to show the central 99.8\% 
of the distribution.}

\item{ylim}{y limits}

\item{return}{If \code{"plot"}, return a plot.  If \code{"values"}, return a vector of numerical values.}

\item{...}{additional arguments, including parameters of the distribution
and additional options for the plot}

\item{refinements}{A list of refinements to the plot.  See \code{\link[ggformula]{gf_refine}()}.}
}
\value{
a vector of quantiles; a plot is printed as a side effect
}
\description{
Illustrated quantile calculations from distributions
}
\details{
The most general function is \code{qdist} which can work with 
any distribution for which a q-function exists.  As a convenience, wrappers are 
provided for several common distributions.
}
\examples{
qdist("norm", seq(.2, .8, by = 0.10))
xqnorm(seq(.2, .8, by = 0.10), mean = 100, sd = 10)
qdist("unif", .5)
xqgamma(.5, shape = 3, scale = 4)
xqgamma(.5, shape = 3, scale = 4, dlwd = 1)
xqbeta(.5, shape1 = .9, shape2 = 1.4, dlwd = 1)
xqchisq(c(.25,.5,.75), df = 3)
xqbinom(c(0.25, 0.85), size = 1000, prob = 0.40)
# displayed as if continuous
xqbinom(c(0.25, 0.85), size = 5000, prob = 0.40)
xpbinom( c(480, 500, 510), size = 1000, prob = 0.48)
xpbinom( c(40, 60), size = 100, prob = 0.5)
xqpois( c(0.25, 0.5, 0.75), lambda = 6, lwd = 3, vlwd = 2)
}
