\docType{data}
\name{LBW}
\alias{LBW}
\title{Risk Factors for Low Birth Weight}
\format{A data frame with 189 observations on the following variables.

   \itemize{
    \item{\code{low}} {low birth weight (0=No (birth weight >= 2500 g) 1=Yes (birth weight < 2500 g)}
    \item{\code{age}} {age of mother (in years)}
    \item{\code{momweight}} {weight of mother at the last menstrual period (in pounds)}
    \item{\code{race}} {race of mother (1 = White, 2 = Black, 3 = Other)}
    \item{\code{smoke}} {Smoking status during pregnancy (0 = No, 1 = Yes)}
    \item{\code{histpreterm}} {history of premature labor (0 = None, 1 = One, etc.)}
    \item{\code{hypertension}} {history of hypertension (0 = No, 1 = Yes)}
    \item{\code{uterineirrit}} {presence of uterine irritability (0 = No, 1 = Yes)}
    \item{\code{numvisit}} {number of physician visits during the first trimester}
    \item{\code{birthweight}} {the actual birth weight (in grams)}
  }}
\usage{
  data(LBW)
}
\description{
  Low birth weight is an outcome that has been of concern
  to physicians for years. This is due to the fact that
  infant mortality rates and birth defect rates are very
  high for babies with low birth weight. A woman's behavior
  during pregnancy (including diet, smoking habits, and
  obtaining prenatal care) can greatly alter her chances of
  carrying the baby to term and, consequently, of
  delivering a baby of normal birth weight. The goal of the
  study was to identify risk factors associated with giving
  birth to a low birth weight baby.
}
\references{
  Part of the Carnegie Mellon University Online Learning
  Initiative datasets.
}
\keyword{datasets}

