% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/aggregatingMeta.R
\name{mean}
\alias{IQR}
\alias{cor}
\alias{cov}
\alias{favstats}
\alias{fivenum}
\alias{iqr}
\alias{max}
\alias{mean}
\alias{median}
\alias{min}
\alias{prod}
\alias{quantile}
\alias{range}
\alias{sd}
\alias{sum}
\alias{var}
\title{Aggregating functions}
\usage{
mean(x, ..., data, groups = NULL, ..fun.. = base::mean,
  na.rm = getOption("na.rm", FALSE))

median(x, ..., data, groups = NULL, ..fun.. = stats::median,
  na.rm = getOption("na.rm", FALSE))

range(x, ..., data, groups = NULL, ..fun.. = base::range,
  na.rm = getOption("na.rm", FALSE))

sd(x, ..., data, groups = NULL, ..fun.. = stats::sd,
  na.rm = getOption("na.rm", FALSE))

max(x, ..., data, groups = NULL, ..fun.. = base::max,
  na.rm = getOption("na.rm", FALSE))

min(x, ..., data, groups = NULL, ..fun.. = base::min,
  na.rm = getOption("na.rm", FALSE))

sum(x, ..., data, groups = NULL, ..fun.. = base::sum,
  na.rm = getOption("na.rm", FALSE))

IQR(x, ..., data, groups = NULL, ..fun.. = stats::IQR,
  na.rm = getOption("na.rm", FALSE))

fivenum(x, ..., data, groups = NULL, ..fun.. = stats::fivenum,
  na.rm = getOption("na.rm", FALSE))

iqr(x, ..., data, groups = NULL, ..fun.. = stats::IQR,
  na.rm = getOption("na.rm", FALSE))

prod(x, ..., data, groups = NULL, ..fun.. = base::prod,
  na.rm = getOption("na.rm", FALSE))

sum(x, ..., data, groups = NULL, ..fun.. = base::sum,
  na.rm = getOption("na.rm", FALSE))

favstats(x, ..., data, groups = NULL, ..fun.. = fav_stats, na.rm = TRUE)

quantile(x, ..., data, groups = NULL, ..fun.. = stats::quantile,
  na.rm = getOption("na.rm", FALSE))

var(x, ..., data, groups = NULL, ..fun.. = stats::var,
  na.rm = getOption("na.rm", FALSE))

cor(x, y = NULL, ..., data = parent.frame())

cov(x, y = NULL, ..., data = parent.frame())
}
\arguments{
\item{x}{an object, often a formula}

\item{data}{a data frame in which to evaluate formulas (or bare names).
Note that the default is \code{data=parent.frame()}.  This makes it convenient to
use this function interactively by treating the working envionment as if it were
a data frame.  But this may not be appropriate for programming uses.
When programming, it is best to use an explicit \code{data} argument
-- ideally supplying a data frame that contains the variables mentioned.}

\item{groups}{a grouping variable, typically a name of a variable in \code{data}}

\item{..fun..}{the underlyin function used in the computation}

\item{na.rm}{a logical indicating whether \code{NA}s should be removed before computing}

\item{y}{an object, often a numeric vector}

\item{\dots}{additional arguments}
}
\description{
The \code{mosaic} package makes several summary statistic functions (like \code{mean} and \code{sd})
formula aware.
}
\examples{
if (require(mosaicData)) {
mean( HELPrct$age )
mean( ~ age, data=HELPrct )
mean( age ~ shuffle(sex), data=HELPrct)
mean( age ~ shuffle(sex), data=HELPrct, .format="table")
# wrap in data.frame() to auto-convert awkward variable names
data.frame(mean( age ~ shuffle(sex), data=HELPrct, .format="table"))
mean( age ~ sex + substance, data=HELPrct )
mean( ~ age | sex + substance, data=HELPrct )
mean( sqrt(age), data=HELPrct )
sum( ~ age, data=HELPrct )
sd( HELPrct$age )
sd( ~ age, data=HELPrct )
sd( age ~ sex + substance, data=HELPrct )
var( HELPrct$age )
var( ~ age, data=HELPrct )
var( age ~ sex + substance, data=HELPrct )
IQR( width ~ sex, data=KidsFeet )
iqr( width ~ sex, data=KidsFeet )
favstats( width ~ sex, data=KidsFeet )

cor( length ~ width, data=KidsFeet )
cov ( length ~ width, data=KidsFeet )
}
}

