% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifetable_corrected.R
\name{lt.correction}
\alias{lt.correction}
\title{Calculates a corrected life table from a mortAAR life table}
\usage{
lt.correction(life_table, agecor = TRUE, agecorfac = c(), option_spline = NULL)
}
\arguments{
\item{life_table}{an object of class mortaar_life_table.}

\item{agecor}{logical, optional. Passed to \code{\link{life.table}}.}

\item{agecorfac}{numeric vector, optional. Passed to \code{\link{life.table}}.}

\item{option_spline}{integer, optional. Passed to \code{\link{life.table}}.}
}
\value{
a list containing a data.frame with indices e0, 1q0 and 5q0 as
well as mortality rate m and growth rate r according to Bocquet-Appel
and Masset showing the computed exact value as well as ranges and an
object of class mortaar_life_table with the corrected values.
\itemize{
  \item \bold{e0}:   Corrected life expectancy.
  \item \bold{1q0}:   Mortality of age group 0--1.
  \item \bold{5q0}:   Mortality of age group 0--5.
}
}
\description{
It is generally assumed that most skeletal populations lack the
youngest age group. Life tables resulting from such populations
will necessarily be misleading as they lead to believe that the
mortality of younger children was lower than it actually was and
that life expectancy was higher. For correcting these missing
individuals, \emph{Bocquet-Appel and Masset} (1977; see also
\emph{Herrmann et al. 1990}, 307) conceived of several
calculations based on regression analyses of modern comparable
mortality data. However, the applicability of these indices
to archaeological data is highly debated and does not necessarily
lead to reliable results. Therefore, the correction needs to be
weighted carefully and ideally only after the representativity of the
base data has been checked with function lt.representativity.
}
\details{
For the parameters see the documentation of \code{\link{life.table}}.
}
\examples{
# Calculate a corrected life table from real life dataset.
schleswig <- life.table(schleswig_ma[c("a", "Dx")])
lt.correction(schleswig)


}
\references{
\insertRef{masset_bocquet_1977}{mortAAR}

\insertRef{herrmann_prahistorische_1990}{mortAAR}
}
