% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproDataCheck.R
\name{reproDataCheck}
\alias{reproDataCheck}
\title{Checks if an object can be used to perform reproduction toxicity data analysis}
\usage{
reproDataCheck(data, diagnosis.plot = TRUE)
}
\arguments{
\item{data}{any object}

\item{diagnosis.plot}{if \code{TRUE}, produces a diagnosis plot}
}
\value{
The function returns a \code{data.frame} similar to the one returned
by \code{\link{survDataCheck}}, except that it may contain the following
additional error \code{id}s:
\itemize{
\item \code{NreproInteger}: column \code{Nrepro} contains values of class other than \code{integer}
\item \code{Nrepro0T0}: \code{Nrepro} is not 0 at time 0 for each concentration and each replicate
\item \code{Nsurvt0Nreprotp1P}: at a given time \eqn{T}, the number of
alive individuals is null and the number of collected offspring is not null
for the same replicate and the same concentration at time \eqn{T+1}
}
}
\description{
The \code{reproDataCheck} function can be used to check if an object
containing data from a reproduction toxicity assay meets the expectations
of the function \code{\link{reproData}}.
}
\details{
Since in morse' reproduction datasets are a special case of survival datasets,
\code{reproDataCheck} performs the same verifications than
\code{\link{survDataCheck}} plus additional ones that are specific to
reproduction data.
}
\note{
If an error of type \code{dataframeExpected} or \code{missingColumn}
is detected, the function
\code{reproDataCheck} is stopped. When no error is detected the
\code{reproDataCheck}
function returns an empty dataframe.
}
\examples{

# Run the check data function
data(copper)
reproDataCheck(copper)

# Now we insert an error in the dataset, by setting a non-zero number of
# offspring at some time, although there is no surviving individual in the
# replicate from the previous time point.
copper[148, "Nrepro"] <- as.integer(1)
reproDataCheck(copper)

}
\seealso{
\code{\link{reproData}}
}
\keyword{check}
