% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survFitTKTD.R
\name{survFitTKTD}
\alias{survFitTKTD}
\title{Fits a TKTD for survival analysis using Bayesian inference}
\usage{
survFitTKTD(data, n.chains = 3, quiet = FALSE)
}
\arguments{
\item{data}{An object of class \code{survData}.}

\item{n.chains}{Number of MCMC chains. The minimum required number of chains
is 2.}

\item{quiet}{If \code{FALSE}, prints logs and progress bar from JAGS.}
}
\value{
The function returns an object of class \code{survFitTKTD}, which is
a list with the following fields:
\item{estim.par}{a table of the estimated parameters (medians) and 95 \%
credible intervals}
\item{mcmc}{an object of class \code{mcmc.list} with the posterior
distributions}
\item{model}{a JAGS model object}
\item{parameters}{a list of the parameters names used in the model}
\item{n.chains}{an integer value corresponding to the number of chains used
for the MCMC computation}
\item{n.iter}{a list of two indices indicating the beginning and end of
monitored iterations}
\item{n.thin}{a numerical value corresponding to the thinning interval}
\item{jags.data}{a list a the data passed to the jags model}
}
\description{
This function estimates the parameters of a TKTD
model for survival analysis using Bayesian inference. In this model,
the survival rate of individuals is modeled as a function of the pollutant's
concentration with a mechanistic description of toxic effects on survival over
time.
}
\details{
Details of the model are presented in the vignette accompanying the package.
}
\examples{

# (1) Load the survival data
data(propiconazole)

# (2) Create an object of class "survData"
dat <- survData(propiconazole)

\dontrun{
# (3) Run the survFitTKTD function
out <- survFitTKTD(dat)

# (4) Summary look the estimated values (parameters)
summary(out)

# (5) Plot the fitted curve
plot(out, adddata = TRUE)

# (6) Plot the fitted curve with ggplot style and CI as spaghetti
plot(out, spaghetti = TRUE , adddata = TRUE, 
     style = "ggplot")
}

}
\keyword{estimation}

