% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.survData.R
\name{summary.survData}
\alias{summary.survData}
\title{Summary for \code{survData} objects}
\usage{
\method{summary}{survData}(object, quiet = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{survData}}

\item{quiet}{when \code{FALSE}, prints summary on standard output}

\item{\dots}{Further arguments to be passed to generic methods}
}
\value{
The function returns a list with the following fields:
\item{NbrepTimeConc}{nb of replicates for all concentrations and time points}
\item{NbsurvTimeConc}{nb of surviving ind. for all concentrations and time points}
}
\description{
The generic \code{summary} S3 method for the \code{survData} class provides
information about the structure of the dataset and the experimental design.
}
\examples{
# (1) Load the data
data(cadmium1)

# (2) Create a survData object
cadmium1 <- survData(cadmium1)

# (3) Summarize the dataset
summary(cadmium1)

}
\keyword{summary}

