% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproFitTT.R
\name{reproFitTT}
\alias{reproFitTT}
\title{Fits a Bayesian exposure-response model for target-time reproduction analysis}
\usage{
reproFitTT(data, stoc.part = "bestfit", target.time = NULL, ecx = c(5, 10,
  20, 50), n.chains = 3, quiet = FALSE)
}
\arguments{
\item{data}{an object of class \code{reproData}}

\item{stoc.part}{stochastic part of the model. Possible values are \code{"bestfit"},
\code{"poisson"} and \code{"gammapoisson"}}

\item{target.time}{defines the observation period. By default the last time point}

\item{ecx}{desired values of \eqn{x} (in percent) for which to compute
\eqn{EC_{x}}{ECx}}

\item{n.chains}{number of MCMC chains. The minimum required number of chains is}

\item{quiet}{if \code{TRUE}, does not print messages and progress bars from JAGS}
}
\value{
The function returns an object of class \code{reproFitTT} which is a list
of the following objects:
\item{DIC}{DIC value of the selected model}
\item{estim.ECx}{a table of the estimated 5, 10, 20 and 50 \% effective
concentrations (by default) and their 95 \% credible intervals}
\item{estim.par}{a table of the estimated parameters as medians and 95 \%
credible intervals}
\item{mcmc}{an object of class \code{mcmc.list} with the posterior distributions}
\item{model}{a JAGS model object}
\item{parameters}{a list of the parameters names used in the model}
\item{n.chains}{an integer value corresponding to the number of chains used
for the MCMC computation.}
\item{n.iter}{a list of two indices indicating the beginning and
the end of monitored iterations}
\item{n.thin}{a numerical value corresponding to the thinning interval}
}
\description{
This function estimates a model of the cumulated reproduction outputs of a
population in a given time period in presence of mortality.
}
\details{
Because some individuals may die during the observation period, the
reproduction rate alone is not sufficient to account for the observed number
of offspring. In addition, we need the time individuals have stayed alive
during the experiment. The \code{reproFitTT} function estimates the number
of individual-days in an experiment between its start and the target time.
This covariable is then used to estimate a relation between the toxicant
concentration and the reproduction rate \emph{per individual-day}.

The \code{reproFitTT} function fits two models, one where inter-individual
variability is neglected ("Poisson" model) and one where it is taken into
account ("gamma-Poisson" model). When setting \code{stoc.part} to
\code{"bestfit"}, a model comparison procedure is used to choose between
them. More details are presented in the vignette accompanying the package.
}
\examples{

# (1) Load the data
data(cadmium1)

# (2) Create an object of class "reproData"
dat <- reproData(cadmium1)

\dontrun{
# (3) Run the reproFitTT function with the log-logistic gamma-poisson model
out <- reproFitTT(dat, stoc.part = "gammapoisson",
                  ecx = c(5, 10, 15, 20, 30, 50, 80), quiet = TRUE)

# (4) Summary look the estimated values (ECx and parameters)
out$estim.ECx
out$estim.par

# (5) Plot the fitted curve with credible limits
plot(out, log.scale = TRUE, ci = TRUE,
     main = "log-logistic gamma-poisson model")

# (6) Plot the fitted curve with ggplot style
require("ggplot2")
plot(out, xlab = expression("Concentration in" ~ mu~g.L^{-1}),
     fitcol = "blue", ci = TRUE, cicol = "blue", style = "ggplot",
     main = "Log-logistic response to concentration")
}

}
\keyword{estimation}

