% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigram.R
\name{draw_bigram_network}
\alias{draw_bigram_network}
\alias{bigram}
\alias{bigram_net}
\alias{word_freq}
\alias{bigram_network_plot}
\title{Draw bigram network using morphological analysis data.}
\usage{
draw_bigram_network(df, ...)

bigram(df, text_id = "text_id", ...)

bigram_net(bigram, rand_seed = 12, threshold = 100, ...)

word_freq(df, bigram_net)

bigram_network_plot(
  bigram_net,
  freq,
  ...,
  arrow_size = 5,
  circle_size = 5,
  text_size = 5,
  font_family = "",
  arrow_col = "darkgreen",
  circle_col = "skyblue",
  x_limits = NULL,
  y_limits = NULL,
  no_scale = FALSE
)
}
\arguments{
\item{df}{A dataframe including result of morphological analysis.}

\item{...}{Extra arguments to internal fuctions.}

\item{text_id}{A dstring to specify text.}

\item{bigram}{A result of bigram().}

\item{rand_seed}{A numeric.}

\item{threshold}{A numeric used as threshold for frequency of bigram.}

\item{bigram_net}{A result of bigram_net().}

\item{freq}{A numeric of word frequency in bigram_net.
Can be got using word_freq().}

\item{arrow_size, circle_size, text_size, }{A numeric.}

\item{font_family}{A string.}

\item{arrow_col, circle_col}{A string to specicy arrow and circle color
in bigram network.}

\item{x_limits, y_limits}{A Pair of numeric to specify range.}

\item{no_scale}{A logical. FALSE: Not draw x and y axis.}
}
\value{
A gg object of bigram network plot.
}
\description{
Draw bigram network using morphological analysis data.
}
\examples{
library(tidyverse)
data(neko_mecab)
data(synonym)
synonym <- 
  synonym \%>\% dplyr::mutate_all(stringi::stri_unescape_unicode)

bigram_neko <- 
  neko_mecab \%>\%
  dplyr::select(-text_id) \%>\%
  dplyr::mutate_all(stringi::stri_unescape_unicode) \%>\%
  magrittr::set_colnames(stringi::stri_unescape_unicode(colnames(.))) \%>\%
  clean_mecab_local(
    use_common_data = TRUE, 
    synonym_df = synonym) \%>\%
  draw_bigram_network()

add_stop_words <- 
  c("\\\\u3042\\\\u308b", "\\\\u3059\\\\u308b", "\\\\u3066\\\\u308b", 
    "\\\\u3044\\\\u308b","\\\\u306e", "\\\\u306a\\\\u308b", "\\\\u304a\\\\u308b", 
    "\\\\u3093", "\\\\u308c\\\\u308b", "*") \%>\% 
  stringi::stri_unescape_unicode()

bigram_review <- 
  review_chamame \%>\%
  dplyr::mutate_all(stringi::stri_unescape_unicode) \%>\%
  magrittr::set_colnames(stringi::stri_unescape_unicode(colnames(.))) \%>\%
  clean_chamame(add_stop_words = add_stop_words) \%>\%
  draw_bigram_network()

}
