% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleaning.R
\name{clean_up}
\alias{clean_up}
\alias{clean_mecab_local}
\alias{clean_chamame}
\alias{pos_filter_mecab_local}
\alias{pos_filter_chamame}
\alias{delete_stop_words}
\alias{replace_words}
\title{Clean up result of morphological analyzed data frame}
\usage{
clean_mecab_local(df, ...)

clean_chamame(df, ...)

pos_filter_mecab_local(df)

pos_filter_chamame(df)

delete_stop_words(df, use_common_data = TRUE, add_stop_words = NULL, ...)

replace_words(
  df,
  synonym_df = NULL,
  synonym_from = NULL,
  synonym_to = NULL,
  ...
)
}
\arguments{
\item{df}{A dataframe including result of morphological analysis.}

\item{...}{Extra arguments to internal fuctions.}

\item{use_common_data}{A logical. TRUE: use data(stop_words).}

\item{add_stop_words}{A string vector adding into stop words.
When use_common_data is TRUE and add_stop_words are given,
both of them will be used as stop_words.}

\item{synonym_df}{A datarame including synonym word pairs.
The first column: replace from, the second: replace to.}

\item{synonym_from, synonym_to}{A string vector. Length of synonym_from and synonym_to
should be the same.
When synonym_df and synonym pairs (synonym_from and synonym_to)
are given, both of them will be used as synonym.}
}
\value{
A dataframe.
}
\description{
Clean up result of morphological analyzed data frame
}
\examples{
data(neko_mecab)
data(synonym)
synonym <- 
  synonym \%>\% dplyr::mutate_all(stringi::stri_unescape_unicode)

neko_mecab \%>\%
  dplyr::select(-text_id) \%>\%
  dplyr::mutate_all(stringi::stri_unescape_unicode) \%>\%
  magrittr::set_colnames(stringi::stri_unescape_unicode(colnames(.))) \%>\%
  clean_mecab_local(
    use_common_data = TRUE, 
    synonym_df = synonym)

}
