% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mopaPredict.R
\name{mopaPredict}
\alias{mopaPredict}
\title{Model prediction}
\usage{
mopaPredict(models, newClim)
}
\arguments{
\item{models}{Model class object (e.g. "glm") or list of model class objects, e.g. as returned by function \code{\link[mopa]{extractFromModel}}.}

\item{newClim}{RasterStack or list of RasterStack objects with variables for projecting}
}
\value{
RasterStack of the projected probabilities
}
\description{
Model projection into a RasterStack
}
\examples{
# SHORT EXAMPLE
destfile <- tempfile()
data.url <- "https://raw.githubusercontent.com/SantanderMetGroup/mopa/master/data/biostack.rda"
download.file(data.url, destfile)
load(destfile, verbose = TRUE)

## Fitted models
data(mods)
?mods

## Model prediction
newClim <- lapply(1:4, function(x){
crop(biostack$future[[x]], extent(-10, 10, 35, 65))
})

prdRS.fut <- mopaPredict(models = mods, newClim = newClim)

\donttest{
# FULL WORKED EXAMPLE
## Load presence data
data(Oak_phylo2)

## Load climate data
destfile <- tempfile()
data.url <- "https://raw.githubusercontent.com/SantanderMetGroup/mopa/master/data/biostack.rda"
download.file(data.url, destfile)
load(destfile, verbose = TRUE)

## Spatial reference
r <- biostack$baseline[[1]]
## Create background grid
bg <- backgroundGrid(r)

## Generate pseudo-absences
RS_random <-pseudoAbsences(xy = Oak_phylo2, background = bg$xy, 
                           exclusion.buffer = 0.083*5, prevalence = -0.5, kmeans = FALSE)
## Model training
fittedRS <- mopaTrain(y = RS_random, x = biostack$baseline, 
                      k = 10, algorithm = "glm", weighting = TRUE)
## Extract fitted models
mods <- extractFromModel(models = fittedRS, value = "model")

## Model prediction
preds <- mopaPredict(models = mods, newClim = biostack$future)
}

}
\references{
Iturbide, M., Bedia, J., Herrera, S., del Hierro, O., Pinto, M., Gutierrez, J.M., 2015. 
A framework for species distribution modelling with improved pseudo-absence generation. Ecological 
Modelling. DOI:10.1016/j.ecolmodel.2015.05.018.
}
\seealso{
\code{\link[mopa]{mopaTrain}}, \code{\link[mopa]{extractFromPrediction}}
}
\author{
M. Iturbide
}
