% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eaf.R
\name{attsurf2df}
\alias{attsurf2df}
\title{Convert a list of attainment surfaces to a single EAF \code{data.frame}.}
\usage{
attsurf2df(x)
}
\arguments{
\item{x}{\code{list()}\cr List of \code{data.frames} or matrices. The names of the list
give the percentiles of the attainment surfaces.  This is the format
returned by \code{\link[=eaf_as_list]{eaf_as_list()}}.}
}
\value{
\code{data.frame()}\cr Data frame with as many columns as objectives and an additional column \code{percentiles}.
}
\description{
Convert a list of attainment surfaces to a single EAF \code{data.frame}.
}
\examples{

data(SPEA2relativeRichmond)
attsurfs <- eaf_as_list(eaf(SPEA2relativeRichmond, percentiles = c(0,50,100)))
str(attsurfs)
eaf_df <- attsurf2df(attsurfs)
str(eaf_df)
}
\seealso{
\code{\link[=eaf_as_list]{eaf_as_list()}}
}
\concept{eaf}
