% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moocore-package.R
\docType{data}
\name{CPFs}
\alias{CPFs}
\title{Conditional Pareto fronts obtained from Gaussian processes simulations.}
\format{
A data frame with 2967 observations on the following 3 variables.
\describe{
\item{\code{f1}}{first objective values.}
\item{\code{f2}}{second objective values.}
\item{\code{set}}{indices of corresponding conditional Pareto fronts.}
}
}
\source{
\insertRef{BinGinRou2015gaupar}{moocore}
}
\usage{
CPFs
}
\description{
The data has the only goal of providing an example of use of \code{\link[=vorobT]{vorobT()}} and
\code{\link[=vorobDev]{vorobDev()}}. It has been obtained by fitting two Gaussian processes on 20
observations of a bi-objective problem, before generating conditional
simulation of both GPs at different locations and extracting non-dominated
values of coupled simulations.
}
\examples{
data(CPFs)
vorobT(CPFs, reference = c(2, 200))
}
\keyword{datasets}
