% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPR.R
\name{plotPR}
\alias{plotPR}
\title{Plot pseudo-residuals}
\usage{
plotPR(m, lag.max = NULL, ncores = 1)
}
\arguments{
\item{m}{A \code{\link{momentuHMM}}, \code{\link{miHMM}}, \code{\link{HMMfits}}, or \code{\link{miSum}} object.}

\item{lag.max}{maximum lag at which to calculate the acf.  See \code{\link[stats]{acf}}.}

\item{ncores}{number of cores to use for parallel processing}
}
\description{
Plots time series, qq-plots (against the standard normal distribution), and sample
ACF functions of the pseudo-residuals for each data stream
}
\details{
\itemize{
\item If some turning angles in the data are equal to pi, the corresponding pseudo-residuals
will not be included. Indeed, given that the turning angles are defined on (-pi,pi], an angle of pi
results in a pseudo-residual of +Inf (check Section 6.2 of reference for more information on the
computation of pseudo-residuals).
\item If some data streams are zero-inflated and/or one-inflated, the corresponding pseudo-
residuals are shown as segments, because pseudo-residuals for discrete data are defined as
segments (see Zucchini and MacDonald, 2009, Section 6.2).
\item For multiple imputation analyses, if \code{m} is a \code{\link{miHMM}} object or a list of \code{\link{momentuHMM}} objects, then
the pseudo-residuals are individually calculated and plotted for each model fit. Note that pseudo-residuals for \code{\link{miSum}} objects (as returned by \code{\link{MIpool}}) are based on pooled parameter 
estimates and the means of the data values across all imputations (and therefore may not be particularly meaningful).
}
}
\examples{
# m is a momentuHMM object (as returned by fitHMM), automatically loaded with the package
m <- example$m

plotPR(m)

}
\references{
Zucchini, W. and MacDonald, I.L. 2009.
Hidden Markov Models for Time Series: An Introduction Using R.
Chapman & Hall (London).
}
