% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alternative_pickHardThreshold.R
\name{pickHardThreshold_alternative}
\alias{pickHardThreshold_alternative}
\title{Alternative implementation of WGCNA::pickHardThreshold}
\source{
\code{\link[WGCNA]{pickHardThreshold}} and \code{\link[WGCNA]{scaleFreeFitIndex}}
}
\usage{
pickHardThreshold_alternative(
  data,
  RsquaredCut = 0.85,
  cutVector = seq(0.1, 0.9, by = 0.05)
)
}
\arguments{
\item{data}{Similarity (correlation) matrix. With entries between 0 and 1 (i.e. absolute values
of correlation matrix)}

\item{RsquaredCut}{desired minimum scale free topology fitting index}

\item{cutVector}{a vector of hard threshold cuts for which the scale free topology fit indices
are to be calculated.}
}
\value{
estimate of an appropriate hard-thresholding cut: the lowest cut for which the scale
free topology fit exceeds \code{RsquaredCut}. If is below \code{RsquaredCut} for all cuts, an
error is thrown.
}
\description{
(INTERNAL) Alternative implementation of \code{\link[WGCNA]{pickHardThreshold}} to
fit to the needs of this package. Most importantly the function was simplified to only apply to
the use case of finding a cut-off value to reduce a correlation matrix. The following changes
were applied in comparison to the original function:
* The function __always__ assumes similarity matrices (i.e. correlation matrices) as input
* Additional settings have been removed (`dataIsExpr`, `moreNetworkConcepts`, `removeFirst`,
`corFnc`, `corOptions`, `nBreaks`)
* The function uses \code{\link{scaleFreeFitIndex_alternative}} for fit index calculation
* Print prompts and additional metrics were removed
* An error message that reports the lowest R-squared computed in case this value did not satisfy
the \code{RsquaredCut} value was added.

Description by \code{\link[WGCNA]{pickHardThreshold}}:Analysis of scale free topology for
multiple hard thresholds. The aim is to help the user pick an appropriate threshold for network
construction.
}
\examples{
adjacency_matrix <- matrix(rnorm(36),nrow=6)
diag(adjacency_matrix) <- 1
RsquaredCut <- 0.001
cutVector <- seq(0.2, 0.8, by = 0.05)
\dontshow{
WGCNA::disableWGCNAThreads()
}
cutEstimate_coarse <- pickHardThreshold_alternative(abs(adjacency_matrix), RsquaredCut,
cutVector)
}
