% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_reduction.R
\name{network_reduction_by_pickHardThreshold}
\alias{network_reduction_by_pickHardThreshold}
\title{Reduces network based on WGCNA::pickHardThreshold function}
\source{
The original implementation of pickHardThreshold is used from
\code{\link[WGCNA]{pickHardThreshold.fromSimilarity}}
}
\usage{
network_reduction_by_pickHardThreshold(
  adjacency_matrix,
  RsquaredCut = 0.85,
  cutVector = seq(0.2, 0.8, by = 0.05),
  method = "pickHardThreshold"
)
}
\arguments{
\item{adjacency_matrix}{Adjacency matrix of correlation values.}

\item{RsquaredCut}{A number indicating the desired minimum scale free topology fitting
index R^2.}

\item{cutVector}{A vector of hard threshold cuts for which the scale free topology fit indices
are to be calculated.}

\item{method}{String. Determines whether the original implementation of
\code{\link[WGCNA]{pickHardThreshold.fromSimilarity}} is used ("pickHardThreshold") or the
alternative implementation contained in this package
\code{\link{pickHardThreshold_alternative}} ("pickHardThreshold_alternative").}
}
\value{
A reduced adjacency matrix of correlations with NA's inserted at positions below
estimated cutoff.
}
\description{
(INTERNAL) This function uses \code{\link[WGCNA]{pickHardThreshold.fromSimilarity}} or an
alternative implementation \code{\link{pickHardThreshold_alternative}} contained in this
package to analyze scale free topology for multiple hard thresholds. Within the first iteration
 a `coarse` cutoff is estimated. If no cutoff is found the function terminates with an error
 message. The second iteration determines a `fine-grained` cutoff based on the first iterations
cut estimate (+/- 0.25) in sequence steps of 0.01.
All values below the cutoff will be set to NA and the reduced adjacency is returned.
}
\examples{
\dontshow{
WGCNA::disableWGCNAThreads()
}
data(mrna_data)
adj_mat <- WGCNA::cor(mrna_data$group1$data)
reduced_by_PHT <- network_reduction_by_pickHardThreshold(adj_mat,
RsquaredCut = 0.1, cutVector = seq(0.2, 0.8, by = 0.05))

}
