% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{graph_metrics}
\alias{graph_metrics}
\title{Analyses metrics of an iGraph object}
\usage{
graph_metrics(graph, verbose = TRUE, return = FALSE)
}
\arguments{
\item{graph}{iGraph object to analyze.}

\item{verbose}{If TRUE graph information is printed.}

\item{return}{If TRUE graph information is returned from function.}
}
\value{
Named list of metrics including vertex count, edge count, number of components,
size of largest component and the relative frequency of zero degree vertices.
}
\description{
This helper function prints or returns multiple metrics of arbitrary
iGraph graph object.
}
\examples{
adj_mat <- matrix(rnorm(36),nrow=6)
graph <- igraph::graph_from_adjacency_matrix(adj_mat)
graph_metrics(graph, verbose = TRUE, return = FALSE)


}
