% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plyZClip.R
\name{plyZClip}
\alias{plyZClip}
\title{Function which will clip a plyFile}
\usage{
plyZClip(plyFile, invertZ = FALSE, button = "right", displayNew = TRUE)
}
\arguments{
\item{plyFile}{an object of classes 'mesh3d' and/or 'shape3d'}

\item{invertZ}{True/False logical indicating whether to clip the surface above
or below the selected point.}

\item{button}{logical either: 'right' (default), 'middle', or 'left' indicating which 
button on the mouse to use to interact with the plyFile}

\item{displayNew}{logical indicating whether or not to display a preview of 
the newly cropped ply surface.}
}
\description{
Function which will find a localized maxima or minima and then clip
the plyFile above or below the selected maxima/minima along the Z-axis
}
\details{
This function works through finding a local extema in a small 
highlighted area then using that as the Z-axis level to crop the surface. 
The function makes a few assumptions. That the occlusal plane is parallel to
the X-Y plane, and is normal to the positive Z-axis. Further, it is intended to 
be used with the occlusal plane oriented toward
the operator. The operator should then highlight a small area of the surface 
in which they believe the extrema of interest (i.e. the Z-level at which the
surface should be cropped) will be captured. This function is intended to crop
tooth files in such a way as to result in a tooth surface containing
only the area of the tooth crown above the lowest point of the occlusal basin.
This cropping procedure is consistent with the RFI measure presented by
Ungar and M'Kirera (2003).

The logical invertZ allows users to account for surfaces which have been 
loaded upside-down. That is, the occlusal basin is normal to the negative
Z-axis. Set invertZ=True and the dental surface will be properly cropped.
}

