% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residualize_over_grid.R
\name{residualize_over_grid}
\alias{residualize_over_grid}
\alias{residualize_over_grid.data.frame}
\title{Compute partial residuals from a data grid}
\usage{
residualize_over_grid(grid, model, ...)

\method{residualize_over_grid}{data.frame}(grid, model, predictor_name, ...)
}
\arguments{
\item{grid}{A data frame representing the data grid, or an object of class
\code{estimate_means} or \code{estimate_predicted}, as returned by the different
\verb{estimate_*()} functions.}

\item{model}{The model for which to compute partial residuals. The data grid
\code{grid} should match to predictors in the model.}

\item{...}{Currently not used.}

\item{predictor_name}{The name of the focal predictor, for which partial residuals
are computed.}
}
\value{
A data frame with residuals for the focal predictor.
}
\description{
This function computes partial residuals based on a data grid,
where the data grid is usually a data frame from all combinations of factor
variables or certain values of numeric vectors. This data grid is usually used
as \code{newdata} argument in \code{predict()}, and can be created with
\code{\link[insight:get_datagrid]{insight::get_datagrid()}}.
}
\section{Partial Residuals}{

For \strong{generalized linear models} (glms), residualized scores are computed as
\code{inv.link(link(Y) + r)} where \code{Y} are the predicted values on the response
scale, and \code{r} are the \emph{working} residuals.

For (generalized) linear \strong{mixed models}, the random effect are also
partialled out.
}

\examples{
\dontshow{if (requireNamespace("marginaleffects", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set.seed(1234)
x1 <- rnorm(200)
x2 <- rnorm(200)
# quadratic relationship
y <- 2 * x1 + x1^2 + 4 * x2 + rnorm(200)

d <- data.frame(x1, x2, y)
model <- lm(y ~ x1 + x2, data = d)

pr <- estimate_means(model, c("x1", "x2"))
head(residualize_over_grid(pr, model))
\dontshow{\}) # examplesIf}
}
\references{
Fox J, Weisberg S. Visualizing Fit and Lack of Fit in Complex Regression
Models with Predictor Effect Plots and Partial Residuals. Journal of
Statistical Software 2018;87.
}
