% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_fordistribution.R
\name{d_reproductiondistn}
\alias{d_reproductiondistn}
\title{The distribution of individual reproduction number}
\usage{
d_reproductiondistn(
  x = 1,
  epi.para = list(mean = 1, disp = 0.5, shift = 0.2),
  offspring.type = "D",
  is.log = FALSE
)
}
\arguments{
\item{x}{A scalar, or a vector of non-negative integer.}

\item{epi.para}{A list (\code{list}) of pre-defined epidemiological parameters for offspring distribution, in the format of \code{list(mean = ?, disp = ?, shift = ?)},
where the three parameters accept non-negative values.
Each parameter can be either a scalar, or a vector.
For the parameters being assigned with values of vectors, the vectors should be of the same length.
For Delaporte distribution, the value of \code{mean} should be larger than the value of \code{shift}.}

\item{offspring.type}{A character label (\code{character}) indicating the type of distribution used to describe the offspring distribution.
It only accepts one of the following values:
\itemize{
\item{\code{"D"}}{ indicates the Delaporte distribution for offspring cases, where reproduction number follows a \emph{shifted gamma} distribution; }
\item{\code{"NB"}}{ indicates the negative binomial distribution for offspring cases, where reproduction number follows a (non-shifted, or standard) \emph{gamma} distribution; }
\item{\code{"G"}}{ indicates the geometric distribution for offspring cases, where reproduction number follows an \emph{exponential} distribution; or }
\item{\code{"P"}}{ indicates the Poisson distribution for offspring cases, where reproduction number follows a \emph{Dirac delta} distribution. }
}
By default, \code{offspring.type = 'D'}.}

\item{is.log}{A logical variable, under which probability would be taken natural logarithm, if \code{is.log = TRUE}.
By default, \code{is.log = FALSE}.}
}
\value{
\code{d_offspringdistn()} is the probability density function (PDF), and it returns value of probability density (non-negative value).
}
\description{
This function (i.e., \code{d_reproductiondistn()}) is the probability density function (PDF) of \strong{individual reproduction number} that was modelled as a shifted gamma distribution.
}
\note{
Only the PDF of individual reproduction number (i.e., \code{d_reproductiondistn()}) was created here (without cumulative distribution, quantile, or random variable generating functions).
The function \code{d_reproductiondistn()} was used mainly for data visualization purpose,
because the distribution of individual reproduction number was not explicitly used in model fitting to the disease contact tracing data.

When \code{offspring.type = "P"}, individual reproduction number follows a \emph{Dirac delta} distribution, which is difficult to return any value, or visualize the PDF, because of the nature of this pulse function.
}
\examples{

## an example to visualize individual reproduction number is as follows.
plot(seq(0.01,9.99, length.out = 1001), d_reproductiondistn(
  x = seq(0,10, length.out = 1001),
  epi.para = list(mean = 2, disp = 1.5, shift = 0.5),
  offspring.type = "D",
  is.log = FALSE
), type = 'l', xlab = 'individual reproduction number', ylab = 'density')

}
\references{
Lloyd-Smith JO, Schreiber SJ, Kopp PE, Getz WM. Superspreading and the effect of individual variation on disease emergence. \emph{Nature}. 2005;438(7066):355-359.
\doi{10.1038/nature04153}

Zhao S, Chong MK, Ryu S, Guo Z, He M, Chen B, Musa SS, Wang J, Wu Y, He D, Wang MH. Characterizing superspreading potential of infectious disease: Decomposition of individual transmissibility. \emph{PLoS Computational Biology}. 2022;18(6):e1010281.
\doi{10.1371/journal.pcbi.1010281}
}
