% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod2rm.r
\name{mod2rm}
\alias{mod2rm}
\title{Moderation Analysis for Two-Instance Repeated Measures Designs}
\usage{
mod2rm(data, Y1, Y2, MOD1, MOD1val = NULL, method = 1)
}
\arguments{
\item{data}{A data frame}

\item{Y1}{Name of the first outcome variable}

\item{Y2}{Name of the second outcome variable}

\item{MOD1}{Name of the moderator variable}

\item{MOD1val}{A vector containing two values of the moderator at which to test for conditional effects (optional).}

\item{method}{Method for dealing with two or more moderators (1 = addition, 2 = multiplication) (currently not supported)}
}
\value{
\item{total}{A list of class "mod2rm" containing:}
  \item{num_mods}{Numeric variable indicating the number of moderators (currently only 1 moderator is supported)}
  \item{mod_binary}{Boolean value indicating whether the moderator is binary or not}
  \item{name_y1}{String variable providing the name of first dependent variable (y1)}
  \item{name_y2}{String variable providing the name of second dependent variable (y2)}
  \item{name_mod}{String variable providing the name of moderator}
  \item{res_mod}{A list including the results of a simple regression, regressing the difference between y1 and y2 on the moderator}
  \item{simp_eff1}{A list including the results of a simple regression, regressing the y1 on the moderator}
  \item{simp_eff2}{A list including the results of a simple regression, regressing the y2 on the moderator}
  \item{cond_eff}{A list including the results of an analysis of conditional effects at different levels of the moderator}
  \item{y1y2_diff}{A list including the results of a repeated measures t-test for y1 and y2}
  \item{sample_size}{Numeric variable indicating the number of complete cases that the analysis is based on}
}
\description{
Moderation analysis for two-instance repeated measures designs, including analyses of simple slopes and conditional effects at values of the moderator.\cr\cr
Currently supports a single continuous or binary moderator. For continuous moderators, two values for conditional effects tests can be specified manually.\cr\cr
Method and design based on: Montoya, A. K. (2018). Moderation analysis in two-instance repeated measures designs: Probing methods and multiple moderator models. \emph{Behavior Research Methods, 51(1)}, 61-82.\cr\cr
}
\examples{
df = data.frame(out1 = c(2,4,5,6,6), out2 = c(7,4,5,1,1), w = c(9,4,4,2,3))
res = mod2rm(df, out1, out2, w)
res = mod2rm(df, out1, out2, w, c(2,5))
summary.mod2rm(res)
}
