% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap}
\alias{bootstrap}
\title{This method computes predicted outcome for each observation in the data
frame using the tree model supplied as an input argument.}
\usage{
bootstrap(i, data, main_model, partition_vars, mtry, new_test_data,
  mobforest_controls, fraction, replace, model, family, prob_cutoff = 0.5)
}
\arguments{
\item{i}{the tree}

\item{data}{A data frame containing the variables in the model.}

\item{main_model}{A model in character format}

\item{partition_vars}{A vector of partition variables}

\item{mtry}{A Random subset of partition variables to be considered at each}

\item{new_test_data}{A data frame representing test data for validating
random forest model. This data is not used in in tree building process.}

\item{mobforest_controls}{An object of class
\code{"\linkS4class{mobforest.control}"} returned by
\link[=mobforest.control]{mobforest.control()}, that contains parameters
controlling the construction of random forest.}

\item{fraction}{number of observations to draw without replacement (only
relevant if replace = FALSE)}

\item{replace}{TRUE or FALSE. replace = TRUE (default) performs
bootstrapping. replace = FALSE performs sampling without replacement.}

\item{model}{A model of class \code{"\link[=StatModel-class]{StatModel}"}
used for fitting observations in current node. This parameter allows
fitting a linear model or generalized linear model with formula y ~ x_1 +
... + x_k. The Parameter "linearModel" fits linear model. The parameter
"glinearModel" fits Poisson or logistic regression model depending upon the
specification of parameter "family" (explained next). If "family" is
specified as binomial() then logistic regression is performed. If the
"family" is specified as poisson() then Poisson regression is performed.}

\item{family}{A description of error distribution and link function to be
used in the model. This parameter needs to be specified if generalized
linear model is considered. The parameter "binomial()" is to be specified
when logistic regression is considered and "poisson()" when Poisson
regression is considered as the node model. The values allowed for this
parameter are binomial() and poisson().}

\item{prob_cutoff}{In case of logistic regression as a node model, the
predicted probabilities for OOB cases are converted into classes (yes/no,
high/low, etc as specified) based on this probability cutoff. If logistic
regression is not considered as node model, the prob_cutoff = NULL. By
default it is 0.5 when parameter not specified (and logistic regression
considered).}
}
\value{
A list model performance metrics including R2/accuracy, predictions, 
MSE, and variable importance
}
\description{
This method computes predicted outcome for each observation in the data
frame using the tree model supplied as an input argument.
}
\examples{
\dontrun{
formula <- as.formula(medv ~ lstat)
# load data
data("BostonHousing", package = "mlbench")
mobforest_controls <- 
  mobforest.control(ntree = 1, mtry = 2, replace = TRUE,
                    alpha = 0.05, bonferroni = TRUE, minsplit = 25)

out <- bootstrap(i, data = BostonHousing, main_model = string.formula(formula),
                 partition_vars = partition_vars <- c("rad", "crim", "tax"),
                 mtry = 2, new_test_data = as.data.frame(matrix(0,0,0)),
                 mobforest_controls = mobforest_controls@mob_control, fraction = 1,
                 replace = TRUE, model = linearModel, family = "", prob_cutoff = .5)
out
}
}
