% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multNormTest.R
\name{test.PU}
\alias{test.PU}
\title{Pudelko test of multivariate normality}
\usage{
test.PU(data, MC.rep = 10000, alpha = 0.05, r = 2)
}
\arguments{
\item{data}{a n x d matrix of d dimensional data vectors.}

\item{MC.rep}{number of repetitions for the Monte Carlo simulation of the critical value.}

\item{alpha}{level of significance of the test.}

\item{r}{a positive number (radius of Ball)}
}
\value{
a list containing the value of the test statistic, the approximated critical value and a test decision on the significance level \code{alpha}: \cr
\describe{
        \item{\code{$Test}}{name of the test.}
        \item{\code{$param}}{value tuning parameter.}
        \item{\code{$Test.value}}{the value of the test statistic.}
        \item{\code{$cv}}{the approximated critical value.}
        \item{\code{$Decision}}{the comparison of the critical value and the value of the test statistic.}
}
}
\description{
Computes the (approximated) Pudelko test of multivariate normality.
}
\details{
This functions evaluates the test statistic with the given data and the specified parameter \code{r}. Since since one has to calculate the supremum of a function inside a d-dimensional Ball of radius \code{r}. In this implementation the \code{\link{optim}} function is used.
}
\examples{
test.PU(MASS::mvrnorm(20,c(0,1),diag(1,2)),r=2,MC=100)

}
\references{
Pudelko, J. (2005), On a new affine invariant and consistent test for multivariate normality, Probab. Math. Statist., 25:43-54.
}
\seealso{
\code{\link{PU}}
}
