% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststatistics.R
\name{PU}
\alias{PU}
\title{Statistic of the Pudelko test}
\usage{
PU(data, r = 2)
}
\arguments{
\item{data}{a n x d numeric matrix of data values.}

\item{r}{a positive number (radius of Ball)}
}
\value{
approximate Value of the test statistic
}
\description{
Approximates the test statistic of the Pudelko test.
}
\details{
This functions evaluates the test statistic with the given data and the specified parameter \code{r}. Since since one has to calculate the supremum of a function inside a d-dimensional Ball of radius \code{r}. In this implementation the \code{\link{optim}} function is used.
}
\examples{
PU(MASS::mvrnorm(20,c(0,1),diag(1,2)),r=2)

}
\references{
Pudelko, J. (2005), On a new affine invariant and consistent test for multivariate normality, Probab. Math. Statist., 25:43–54.
}
