% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pbetaDiff}
\alias{pbetaDiff}
\title{Differentiate Regularized Incomplete Beta Function.}
\usage{
pbetaDiff(x, p = 10, q = 0.5, n = 10L, is_validation = TRUE, control = NULL)
}
\arguments{
\item{x}{numeric vector of values between 0 and 1. It is similar to
\code{q} argument of \code{\link[stats]{pbeta}} function.}

\item{p}{similar to \code{shape1} argument of 
\code{\link[stats]{pbeta}} function.}

\item{q}{similar to \code{shape2} argument of 
\code{\link[stats]{pbeta}} function.}

\item{n}{positive integer representing the number of iterations used
to calculate the derivatives. Greater values provide higher accuracy by the
cost of more computational resources.}

\item{is_validation}{logical; if \code{TRUE} then input arguments are
validated. Set to \code{FALSE} to slightly increase the performance
of the function.}

\item{control}{list of control parameters. Currently not intended 
for the users.}
}
\value{
The function returns a list which has the following elements:
\itemize{
\item \code{dx} - numeric vector of derivatives respect to each 
element of \code{x}.
\item \code{dp} - numeric vector of derivatives respect to \code{p} for
each element of \code{x}.
\item \code{dq} - numeric vector of derivatives respect to \code{q} for
each element of \code{x}.
}
}
\description{
Calculate derivatives of the regularized incomplete 
beta function that is a cumulative distribution function of the beta
distribution.
}
\details{
The function implements differentiation algorithm of 
R. Boik and J. Robinson-Cox (1998). 
Currently only first-order derivatives are considered.
}
\examples{
# Some values from Table 1 of R. Boik and J. Robinson-Cox (1998)
pbetaDiff(x = 0.001,  p = 1.5, q = 11)
pbetaDiff(x = 0.5,  p = 1.5, q = 11)

# Compare analytical and numeric derivatives
delta <- 1e-6
x <- c(0.01, 0.25, 0.5, 0.75, 0.99)
p <- 5
q <- 10
out <- pbetaDiff(x = x, p = p, q = q)
p0 <- pbeta(q = x, shape1 = p, shape2 = q)

# Derivatives respect to x
p1 <- pbeta(q = x + delta, shape1 = p, shape2 = q)
data.frame(numeric = (p1 - p0) / delta, analytical = out$dx)
  
# Derivatives respect to p
p1 <- pbeta(q = x, shape1 = p + delta, shape2 = q)
data.frame(numeric = (p1 - p0) / delta, analytical = out$dp)

# Derivatives respect to q
p1 <- pbeta(q = x, shape1 = p, shape2 = q + delta)
data.frame(numeric = (p1 - p0) / delta, analytical = out$dq)

}
\references{
Boik, R. J. and Robinson-Cox, J. F. (1998). Derivatives of the 
Incomplete Beta Function. Journal of Statistical Software, 3 (1),
pages 1-20.
}
