% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnis_general_election_results.R
\name{mnis_general_election_results}
\alias{mnis_general_election_results}
\alias{mnis_GeneralElectionResults}
\title{mnis_general_election_results}
\usage{
mnis_general_election_results(locationType = "Country",
  locationName = "Great Britain", startDate = "1900-01-01",
  endDate = Sys.Date())
}
\arguments{
\item{locationType}{The type of area to return information for. Accepts 'Country', 'Region', 'County', and 'Constituency'. Defaults to 'Country'.}

\item{locationName}{The location to return data for. It can be the name of any Country, Region, County or Constituency. Defaults to 'Great Britain'.}

\item{startDate}{Start date of search. In yyyy-mm-dd format. Defaults to '1900-01-01' if no date is selected.}

\item{endDate}{End date of search. In yyyy-mm-dd format. Defaults to current date if no date is selected.}
}
\value{
Returns a list with details of the search parameter and a data frame with election results.
}
\description{
Returns a list with details of the search parameter and a data frame with election results.
}
\examples{
\dontrun{
x <- mnis_general_election_results(locationType = 'Country', locationName = 'England',
                                 startDate = '2010-01-01', endDate = '2016-01-01')
}
}
\keyword{mnis}
