% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdf.R
\name{cdf}
\alias{cdf}
\alias{cdf.default}
\alias{plot.cdf}
\title{Generates and plots a cumulative distribution function.}
\usage{
cdf(x, ...)

\method{cdf}{default}(x, y, discrete = TRUE, ...)

\method{plot}{cdf}(x, y, ..., col.01line = "black", pch = 19)
}
\arguments{
\item{x}{numeric: x-values}

\item{...}{further parameters given to \code{\link[graphics:plot.default]{graphics::plot()}}}

\item{y}{numeric: y-values}

\item{discrete}{logical: if distribution is discrete}

\item{col.01line}{color: color of horizontal lines at 0 and 1 (default: \code{black})}

\item{pch}{point type: See \code{\link[graphics:points]{graphics::points()}} for possible values and their interpretation (default: \code{19})}
}
\value{
returns a \code{cdf} object
}
\description{
Generates and plots a cumulative distribution function.
}
\examples{
# Binomial distribution
x <- cdf(0:10, pbinom(0:10, 10, 0.5))
plot(x)
# Exponential distribution
x <- seq(0, 5, by=0.01)
x <- cdf(x, pexp(x), discrete=FALSE)
plot(x)
}
