% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical.R
\name{h_get_empirical}
\alias{h_get_empirical}
\title{Obtain Empirical/Jackknife/Bias-Reduced Covariance}
\usage{
h_get_empirical(tmb_data, theta, beta, beta_vcov, type)
}
\arguments{
\item{tmb_data}{(\code{mmrm_tmb_data})\cr produced by \code{\link[=h_mmrm_tmb_data]{h_mmrm_tmb_data()}}.}

\item{theta}{(\code{numeric})\cr theta estimate.}

\item{beta}{(\code{numeric})\cr beta estimate.}

\item{beta_vcov}{(\code{matrix})\cr covariance of beta estimate.}

\item{type}{(\code{string})\cr type of empirical method, including "Empirical", "Empirical-Jackknife"
and "Empirical-Bias-Reduced".}
}
\value{
Named list with elements:
\itemize{
\item \code{cov}: \code{matrix} empirical covariance.
\item \code{g_mat}: \code{matrix} to calculate Satterthwaite degrees of freedom.
}
}
\description{
Obtain the empirical or Jackknife covariance for \eqn{\beta}.
Used in \code{mmrm} fitting if method is "Empirical", "Empirical-Jackknife" or
"Empirical-Bias-Reduced".
}
\note{
This function used to return \code{df_mat}, which was equivalent to \code{crossproduct(g_mat)}. However,
executing the cross product in C++ was a costly matrix multiplication, in particular when the number of coefficients
and/or the number of subjects was large. Therefore this is now avoided and \code{g_mat} is returned instead.
}
\keyword{internal}
