% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit_single_optimizer}
\alias{fit_single_optimizer}
\title{Fitting an MMRM with Single Optimizer}
\usage{
fit_single_optimizer(
  formula,
  data,
  weights,
  reml = TRUE,
  ...,
  control = mmrm_control(...)
)
}
\arguments{
\item{formula}{(\code{formula})\cr the model formula, see details.}

\item{data}{(\code{data})\cr the data to be used for the model.}

\item{weights}{(\code{vector})\cr an optional vector of weights to be used in the fitting process.
Should be NULL or a numeric vector.}

\item{reml}{(\code{flag})\cr whether restricted maximum likelihood (REML) estimation is used,
otherwise maximum likelihood (ML) is used.}

\item{...}{Additional arguments to pass to \code{\link[=mmrm_control]{mmrm_control()}}.}

\item{control}{(\code{mmrm_control})\cr object.}
}
\value{
The \code{mmrm_fit} object, with additional attributes containing warnings,
messages, optimizer used and convergence status in addition to the
\code{mmrm_tmb} contents.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function helps to fit an MMRM using \code{TMB} with a single optimizer,
while capturing messages and warnings.
}
\details{
\code{fit_single_optimizer} will fit the \code{mmrm} model using the \code{control} provided.
If there are multiple optimizers provided in \code{control}, only the first optimizer
will be used.
}
\examples{
mod_fit <- fit_single_optimizer(
  formula = FEV1 ~ RACE + SEX + ARMCD * AVISIT + us(AVISIT | USUBJID),
  data = fev_data,
  weights = rep(1, nrow(fev_data)),
  optimizer = "nlminb"
)
attr(mod_fit, "converged")
}
