% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext.R
\name{replext}
\alias{replext}
\title{Launch Replext Simulation Shiny Application}
\usage{
replext()
}
\description{
This function creates and launches a Shiny web application for running
simulations related to constrained statistical inference in ANOVA and regression
settings. The application allows users to set various parameters for
\code{replext_t1_c1} and \code{replext_t2_c1} functions and view the resulting simulation
data. The simulation is based on Vanbrabant et al. (2015).
}
\details{
The Shiny application consists of a user interface for setting
simulation parameters and a server logic to process the simulations. Users can
select between different simulation settings (cell blocks), specify parameters,
run the simulations, view the results in a table format, and download the
results. The application also handles dynamic UI elements based on user
selections and manages data downloads.

The app's UI includes:
\itemize{
\item A sidebar for input parameters and action buttons.
\item A main panel for displaying simulation results.
}

The server logic includes:
\itemize{
\item Rendering parameter input UI based on selected cell block.
\item Running simulations and storing results.
\item Rendering and exporting the results table.
}
}
\examples{
# Launch the Replext Simulation Shiny application
if(interactive()){
  replext()
}

}
\references{
Vanbrabant, Leonard; Van De Schoot, Rens; Rosseel, Yves (2015). Constrained
statistical inference: sample-size tables for ANOVA and regression. Frontiers
in Psychology, 5. DOI:10.3389/fpsyg.2014.01565.
URL: https://www.frontiersin.org/articles/10.3389/fpsyg.2014.01565
}
