% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateRunCode.R
\name{generateRunCode}
\alias{generateRunCode}
\title{Generate a Unique Run Code}
\usage{
generateRunCode(time_format = "\%Y\%m\%d\%H\%M\%S", string_length = 5)
}
\arguments{
\item{time_format}{A string specifying the format for the timestamp.
Default is "\%Y\%m\%d\%H\%M\%S" (year, month, day, hour, minute, second).}

\item{string_length}{An integer specifying the length of the random string.
Default is 5.}
}
\value{
A character string containing the unique run code, composed of
a timestamp and a random alphanumeric string, separated by an underscore.
}
\description{
This function generates a unique run code for use in Shiny applications,
particularly those running simulations. The code combines a timestamp
with a random string to ensure uniqueness for each row or run.
}
\note{
This function uses the current system time and a random string
to generate the run code. While collisions are extremely unlikely,
they are theoretically possible, especially if the function is called
multiple times within the same second and with a short string_length.
}
\examples{
generateRunCode()
generateRunCode(time_format = "\%Y\%m\%d", string_length = 8)

}
