% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_game_mgmt.R
\name{swapper}
\alias{swapper}
\title{Card Matrix Swapping Function}
\usage{
swapper(cards_matrix, swap_cols = NULL, swap_in_col = NULL, swap_in_row = NULL)
}
\arguments{
\item{cards_matrix}{A matrix representing the card grid on which to perform swaps.}

\item{swap_cols}{A numeric vector of length 2 specifying the columns to swap.}

\item{swap_in_col}{A single integer indicating a column where the two cards
will be swapped.}

\item{swap_in_row}{A numeric vector of length 3 indicating the row number
followed by the two column numbers within that row to swap.}
}
\value{
A matrix of the same dimensions as \code{cards_matrix} with the specified
swaps performed.
}
\description{
This function performs swapping operations within a card matrix to rearrange
cards. It can swap entire columns, swap cards within a single column, or swap
cards within a single row. It is designed to be used on a replication study
card grid before generating replication study data.
}
\details{
The \code{swapper} function can be used to rearrange cards in a card matrix. It allows
for three types of swaps:
\itemize{
\item Swapping two columns: Specify two columns to swap their entire content.
\item Swapping within a column: Reverse the order of two cards in the same column.
\item Swapping within a row: Swap two cards within the same row.
}

The function keeps track of the swapping history to prevent multiple swaps within
the same column or row, as these are restricted operations. After a swap operation,
the function updates the class of the \code{cards_matrix} to include "swapper" to track
its history.
}
\examples{
swapper(cards_matrix = deal_cards_to_rc_grid(n = 3), swap_cols = c(1,2))

}
