% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_game_mgmt.R
\name{process_original_study}
\alias{process_original_study}
\title{Process Original Study Data for Analysis}
\usage{
process_original_study(df, alpha = 0.05)
}
\arguments{
\item{df}{A data frame containing the study data, with columns \code{ColLabs} for
labels and \code{ColVals} for values.}

\item{alpha}{Significance level for the statistical tests, by default set to
0.05.}
}
\value{
A list containing elements for hypothesis, pairwise t-tests
(if applicable), fit summary, descriptives, fit object, Shapiro-Wilk normality
test result, and Levene's test result.
}
\description{
This function processes the original study data by performing ANOVA,
post-hoc t-tests, and checking assumptions such as normality of residuals and
homogeneity of variances.
}
\details{
The function starts by fitting an ANOVA model to the data to check for overall
significance. If significant differences are found, it proceeds with pairwise
t-tests to explore differences between individual conditions.

The function then checks for normality of residuals using the Shapiro-Wilk test
and for homogeneity of variances using Levene's test. It constructs a hypothesis
string based on the results of the pairwise t-tests.

A directed graph is created to represent the relationships between the conditions.
The graph is then simplified to reflect the most direct relationships, which
are used to construct the final hypothesis string.

Descriptive statistics are generated for each condition using the
generate_descriptives() internal function.

The function returns a list with the following components:
\itemize{
\item \code{hypothesis}: A string representing the simplified relationships between conditions.
\item \code{pairwise_t}: The result of pairwise t-tests, if performed.
\item \code{fit_summary}: The summary of the ANOVA model.
\item \code{descriptives}: Descriptive statistics for each condition.
\item \code{fit}: The ANOVA model object.
\item \code{shapiro_test}: The result of the Shapiro-Wilk normality test.
\item \code{levene_test}: The result of Levene's test for homogeneity of variances.
}
}
\examples{
results <- process_original_study(df = generate_study_data(
                                       x = deal_cards_to_rc_grid(n = 3),
                                       sample_size = 30),
                                  alpha = 0.05)
}
