% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{components}
\alias{components}
\alias{components.default}
\title{Find connected components}
\usage{
components(x, kernel, ...)

\method{components}{default}(x, kernel, ...)
}
\arguments{
\item{x}{Any object. For the default method, this must be coercible to an
array.}

\item{kernel}{An object representing the kernel to be used, which must be
coercible to an array. It must have odd width in all dimensions, but does
not have to be isotropic in size. The kernel's dimensionality may be less
than that of the target array, \code{x}. See \code{\link{kernels}} for
kernel-generating functions.}

\item{\dots}{Additional arguments to methods.}
}
\value{
An array of the same dimension as the original, whose integer-valued
  elements identify the component to which each element in the array
  belongs. Zero values in the original array will result in NAs.
}
\description{
The \code{components} function finds connected components in a numeric
array. The kernel determines which neighbours are considered connected (e.g.
including or excluding diagonal neighbours), and will usually have width 3
in each dimension.
}
\examples{
x <- c(0,0,1,0,0,0,1,1,1,0,0)
k <- c(1,1,1)
components(x,k)
}
\author{
Jon Clayden <code@clayden.org>
}
\seealso{
\code{\link{kernels}} for kernel-generating functions.
}

