% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09-opal_functions.R
\name{opal_tables_pull}
\alias{opal_tables_pull}
\title{Download tables from an Opal project as a dossier}
\usage{
opal_tables_pull(
  opal,
  project,
  table_list = NULL,
  content = c("dataset", "data_dict"),
  keep_as_dossier = TRUE,
  .remove_id = FALSE
)
}
\arguments{
\item{opal}{Opal login attributes.}

\item{project}{A character string specifying the Opal project name.}

\item{table_list}{A vector character string specifying Opal tables name.}

\item{content}{A vector of character string which indicates if the
function returns a dataset, or data dictionary. Default is 'dataset'.}

\item{keep_as_dossier}{whether to return a dossier or a dataset if there is
only one table. TRUE by default, if FALSE returns dataset.}

\item{.remove_id}{whether to return the id column created in Opal or not.
TRUE by default.}
}
\value{
Objects (tibbles and list of tibbles) representing tables and their
respective data dictionary.
}
\description{
Downloads a dossier or dataset from an Opal environment to the local
environment. This is a wrapper function for\code{\link[opalr:opal.table_get]{opalr::opal.table_get()}} and
\code{\link[opalr:opal.table_dictionary_get]{opalr::opal.table_dictionary_get()}}.
}
\details{
Opal is the OBiBa application for data management, and Opal environments can
be integrated with RStudio environments using the package \code{opalr}.
The user must have adequate credentials to interact with a specific Opal
environment. Some function errors produced may be associated with the
handler or Opal read/write permissions.
}
\examples{
\dontrun{

library(opalr)
opal <- 
 opal.login('administrator','password',
   url ='https://opal-demo.obiba.org/')
   
# use DEMO_files provided by the package
library(madshapR)
library(stringr)

dossier <- 
  DEMO_files[str_detect(names(DEMO_files),"dataset_MELBOURNE")]

tempdir <- basename(tempdir())
try(opal_project_create(opal, tempdir))

try(
  opal_tables_push(
  opal, dossier,project_name = tempdir, .force = TRUE, .overwrite = TRUE))
  
###### Example pull a table from a project.
try(
  opal_tables_pull(
  opal,project = tempdir,table_list = 'dataset_MELBOURNE_1'))

}

}
\seealso{
Please see \href{https://opaldoc.obiba.org/}{Opal documentation} for
complete documentation.
\code{\link[madshapR:as_dossier]{madshapR::as_dossier()}}
\code{\link[madshapR:as_dataset]{madshapR::as_dataset()}}
\code{\link[madshapR:as_data_dict_mlstr]{madshapR::as_data_dict_mlstr()}}
}
