% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{clearRI}
\alias{clearRI}
\title{Clear Retrafo and Inverter Attributes}
\usage{
clearRI(data)
}
\arguments{
\item{data}{[\code{\link[base]{data.frame}} | \code{\link[mlr]{Task}} | \code{\link[mlr:makeWrappedModel]{WrappedModel}}]\cr
The result of a \code{\link{CPO}} applied to a data set.}
}
\value{
[\code{\link[base]{data.frame}} | \code{\link[mlr]{Task}} | \code{\link[mlr:makeWrappedModel]{WrappedModel}}] the
  \code{data} after stripping all \code{retrafo} and \code{inverter} attributes.
}
\description{
When applying \code{\link{CPO}}s to data, the operation entails
saving the \code{\link{CPOTrained}} information that gets generated
to an attribute of the resulting object. This is a useful solution to
the problem that applying multiple CPOs should also lead to a retrafo
object that performs the same multiple operations. However, sometimes
this may lead to surprising and unwanted results when a CPO is applied
and not meant to be part of a trafo-retrafo machine learning pipeline,
e.g. for dropping columns that occur in training but not in prediction
data. In that case, it is necessary to reset the \code{retrafo} and
possibly \code{inverter} attributes of the data being used. This can
be done either by using \code{retrafo(data) <- NULL}, or by using
\code{clearRI}. \code{clearRI} clears both \code{retrafo} \emph{and}
\code{inverter} attributes.
}
\examples{
# without clearRI
transformed = iris.task \%>>\% cpoPca()
transformed2 = transformed \%>>\% cpoScale()
retrafo(transformed2)  # [RETRAFO pca]=>[RETRAFO scale]

transformed = iris.task \%>>\% cpoPca()
transformed2 = clearRI(transformed) \%>>\% cpoScale()
retrafo(transformed2)  # [RETRAFO scale]

}
\seealso{
Other retrafo related: \code{\link{CPOTrained}},
  \code{\link{NULLCPO}}, \code{\link{\%>>\%}},
  \code{\link{applyCPO}}, \code{\link{as.list.CPO}},
  \code{\link{getCPOClass}}, \code{\link{getCPOName}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOProperties}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{getCPOTrainedState}},
  \code{\link{is.retrafo}},
  \code{\link{makeCPOTrainedFromState}},
  \code{\link{pipeCPO}}, \code{\link{print.CPOConstructor}}

Other inverter related: \code{\link{CPOTrained}},
  \code{\link{NULLCPO}}, \code{\link{\%>>\%}},
  \code{\link{applyCPO}}, \code{\link{as.list.CPO}},
  \code{\link{getCPOClass}}, \code{\link{getCPOName}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOProperties}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{getCPOTrainedState}},
  \code{\link{is.inverter}},
  \code{\link{makeCPOTrainedFromState}},
  \code{\link{pipeCPO}}, \code{\link{print.CPOConstructor}}
}
