% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnsembleFSResult.R
\name{autoplot.EnsembleFSResult}
\alias{autoplot.EnsembleFSResult}
\title{Plots for Ensemble Feature Selection Results}
\usage{
\method{autoplot}{EnsembleFSResult}(
  object,
  type = "pareto",
  pareto_front = "stepwise",
  stability_measure = "jaccard",
  stability_args = NULL,
  theme = theme_minimal(),
  ...
)
}
\arguments{
\item{object}{(\link[mlr3fselect:ensemble_fs_result]{mlr3fselect::EnsembleFSResult}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{pareto_front}{(\code{character(1)})\cr
Type of pareto front to plot. Can be \code{"stepwise"} (default), \code{"estimated"}
or \code{"none"}.}

\item{stability_measure}{(\code{character(1)})\cr
The stability measure to be used in case \code{type = "stability"}.
One of the measures returned by \code{\link[stabm:listStabilityMeasures]{stabm::listStabilityMeasures()}} in lower case.
Default is \code{"jaccard"}.}

\item{stability_args}{(\code{list})\cr
Additional arguments passed to the stability measure function.}

\item{theme}{(\code{\link[ggplot2:theme]{ggplot2::theme()}})\cr
The \code{\link[ggplot2:ggtheme]{ggplot2::theme_minimal()}} is applied by default to all plots.}

\item{...}{(ignored).}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Visualizations for \link[mlr3fselect:ensemble_fs_result]{EnsembleFSResult}.
The argument \code{type} determines the type of plot generated.
The available options are:
\itemize{
\item \code{"pareto"} (default): Scatterplot of performance versus the number of
features, possibly including the \strong{Pareto front}, which allows users to
decide how much performance they are willing to trade off for a more sparse
model.
\item \code{"performance"}: Boxplot of performance across the different learners
used in the ensemble feature selection process.
Each box represents the distribution of scores across different resampling
iterations for a particular learner.
\item \verb{"n_features}: Boxplot of the number of features selected by each learner
in the different resampling iterations.
\item \code{"stability"}: Barplot of stability score for each learner used in the
ensemble feature selection. This plot shows how similar are the output feature
sets from each learner across the different resamplings.
}
}
\examples{
\donttest{
if (requireNamespace("mlr3")) {
  library(mlr3)
  library(mlr3fselect)

  set.seed (42)
  efsr = ensemble_fselect(
    fselector = fs("random_search"),
    task = tsk("sonar"),
    learners = lrns(c("classif.rpart", "classif.featureless")),
    init_resampling = rsmp("subsampling", repeats = 5),
    inner_resampling = rsmp("cv", folds = 3),
    measure = msr("classif.ce"),
    terminator = trm("evals", n_evals = 5)
  )

  # Pareto front (default, stepwise)
  autoplot(efsr)

  # Pareto front (estimated)
  autoplot(efsr, pareto_front = "estimated")

  # Performance
  autoplot(efsr, type = "performance")

  # Number of features
  autoplot(efsr, type = "n_features")

  # stability
  autoplot(efsr, type = "stability")
}
}
}
