% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimInstanceSingleCrit.R
\name{autoplot.OptimInstanceSingleCrit}
\alias{autoplot.OptimInstanceSingleCrit}
\title{Plot for OptimInstanceSingleCrit}
\usage{
\method{autoplot}{OptimInstanceSingleCrit}(
  object,
  type = "marginal",
  cols_x = NULL,
  trafo = FALSE,
  learner = mlr3::lrn("regr.ranger"),
  grid_resolution = 100,
  batch = NULL,
  ...
)
}
\arguments{
\item{object}{(\link[bbotk:OptimInstanceSingleCrit]{bbotk::OptimInstanceSingleCrit}.}

\item{type}{(\code{character(1)}):
Type of the plot. Available choices:
\itemize{
\item \code{"marginal"}: scatter plots of x versus y The
colour of the points shows the batch number.
\item \code{"performance"}: scatter plots of batch number versus y
\item \code{"parameter"}: scatter plots of batch number versus input. The
colour of the points shows the y values.
\item \code{"parallel"} parallel coordinates plot. x values are rescaled by
\code{(x - mean(x)) / sd(x)}.
\item \code{"points"} - scatter plot of two x dimensions versus y The
colour of the points shows the y values.
\item \code{"surface"}: surface plot of two x dimensions versus y values.
The y values are interpolated with the supplied
\link[mlr3:Learner]{mlr3::Learner}.
\item \code{"pairs"}: plots all x and y values against each other.
}}

\item{cols_x}{(\code{character()})\cr
Column names of x values. By default, all untransformed
x values from the search space are plotted. Transformed hyperparameters are prefixed with
\code{x_domain_}.}

\item{trafo}{(\code{logical(1)})\cr
Determines if untransformed (\code{FALSE}) or transformed (\code{TRUE})
x values are plotted.}

\item{learner}{(\link[mlr3:Learner]{mlr3::Learner})\cr
Regression learner used to interpolate the data of the surface plot.}

\item{grid_resolution}{(\code{numeric()})\cr
Resolution of the surface plot.}

\item{batch}{(\code{integer()})\cr
The batch number(s) to limit the plot to. Default is all batches.}

\item{...}{(\code{any}):
Additional arguments, possibly passed down to the underlying plot functions.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Generates plots for \link[bbotk:OptimInstanceSingleCrit]{bbotk::OptimInstanceSingleCrit}.
}
\section{Theme}{

The \code{\link[=theme_mlr3]{theme_mlr3()}} and viridis color maps are applied by default to all
\code{autoplot()} methods. To change this behavior set
\code{options(mlr3.theme = FALSE)}.
}

\examples{
if (requireNamespace("bbotk") && requireNamespace("patchwork")) {
  library(bbotk)
  library(paradox)

  fun = function(xs) {
    c(y = -(xs[[1]] - 2)^2 - (xs[[2]] + 3)^2 + 10)
  }
  domain = ps(
    x1 = p_dbl(-10, 10),
    x2 = p_dbl(-5, 5)
  )
  codomain = ps(
    y = p_dbl(tags = "maximize")
  )
  obfun = ObjectiveRFun$new(
    fun = fun,
    domain = domain,
    codomain = codomain
  )

  instance = OptimInstanceSingleCrit$new(objective = obfun, terminator = trm("evals", n_evals = 20))

  optimizer = opt("random_search", batch_size = 2)
  optimizer$optimize(instance)

  # plot y versus batch number
  autoplot(instance, type = "performance")

  # plot x1 values versus performance
  autoplot(instance, type = "marginal", cols_x = "x1")

  # plot parallel coordinates plot
  autoplot(instance, type = "parallel")

  # plot pairs
  autoplot(instance, type = "pairs")
}
}
